/*++Contact.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar CONTACT property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.4.2 [2445]
 *   occurs:	VEVENT (0+)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	ALTREP(0-1), LANGUAGE(0-1), xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Contact
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CONTACT property, unset.
   */
  public
  Contact  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CONTACT property set to supplied value.
   */
  public
  Contact  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Contact;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( AltRepParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/01/15  slh
 *        getCalendarName()
 *        derive directly from TextProp
 *        configProperty()
 *  0.00  2001/04/25  slh
 *        create
 */
/*--Contact.java------------------------------------------------------------*/
