/*++Config.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.lang.reflect.InvocationTargetException;
import  java.util.HashMap;
import  java.util.Iterator;
import  java.util.Map;


/**
 * Class paths, classes, etc.
 *
 * @author  slh
 * @version  0.01 2003/10/29 slh
 */
abstract public
class  Config
{

/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Call this early on.
   */
  static public
  void
  init  (boolean	bProcessTexts	)
  {
    mc_bProcessTexts = bProcessTexts;
  }


  /**
   * Call this early on.
   */
  static public
  void
  init  (		)
  {
    /*void*/init( false );
  }


  static public
  void
  setProcessTexts  (boolean	bProcessTexts	)
  {
    mc_bProcessTexts = bProcessTexts;
  }


  /**
   * Is value an IANA token?
   */
  static public
  boolean
  isIANAToken  (String	strValue	)
  {
    return false;	/* currently, do not know any */
  }


  /**
   * Is value an x-name?
   */
  static public
  boolean
  isXName  (String	strValue	)
  {
    return strValue.startsWith( "X-" );
  }


  static public
  java.lang.Class
  getCompClass  (String	strName	)
  {
    Object	objClass;

    objClass = valueToKey( hmClassToNameAllComponent , strName );
    if (null == objClass && isIANAToken( strName )) {
      objClass = IANAComp.class;
    }
    if (null == objClass && isXName( strName )) {
      objClass = XComp.class;
    }

    return (java.lang.Class)objClass;
  }


  static public
  java.lang.Class
  getPropClass  (String	strName	)
  {
    Object	objClass;

    objClass = valueToKey( hmClassToNameAllProperty , strName );
    if (null == objClass && isIANAToken( strName )) {
      objClass = IANAProp.class;
    }
    if (null == objClass && isXName( strName )) {
      objClass = XProp.class;
    }

    return (java.lang.Class)objClass;
  }


  static public
  java.lang.Class
  getParamClass  (String	strName	)
  {
    Object	objClass;

    objClass = valueToKey( hmClassToNameAllParameter , strName );
    if (null == objClass && isIANAToken( strName )) {
      objClass = IANAParam.class;
    }
    if (null == objClass && isXName( strName )) {
      objClass = XParam.class;
    }

    return (java.lang.Class)objClass;
  }


/*----------------------------------------------------------------------------
 *						Class Protected Methods
 *--------------------------------------------------------------------------*/

  static protected
  String
  getCalendarName  (java.lang.Class	jlclass	)
  {
//???
    String	strName		= null;

//???this try/catch will become the only method once getCalendarName() is done
    try {
      strName = (String)jlclass.getMethod( "getCalendarName" , null ).
		invoke( null , null );
    } catch (NoSuchMethodException	e	) {
//???probably just merge all of these, do nothing and let method return null
      ;
    } catch (IllegalAccessException	e	) {
//???
      ;
    } catch (InvocationTargetException	e	) {
      /* this should not happen for getCalendarName();
	 or at least not if we get the right one */
//???
      ;
    }
    if (null == strName) {
      strName = (String)hmClassToNameAllComponent.get( jlclass );
    }
    if (null == strName) {
      strName = (String)hmClassToNameAllProperty.get( jlclass );
    }
    if (null == strName) {
      strName = (String)hmClassToNameAllParameter.get( jlclass );
    }

    return strName;
  }


  /**
   * Add key/value to HashMap.
   */
  static protected
  void
  putClassToName  (HashMap		hm	,
		   java.lang.Class	jlclass	,
		   String		strName	)
  {
    /*void*/putUniq( hm , jlclass , strName );
  }


  /**
   * Add HashMap to HashMap.
   */
  static protected
  void
  putAllClassToName  (HashMap	hmAll	,
		      HashMap	hmAdd	)
  {
    /*void*/putAllUniq( hmAll , hmAdd );
  }


/*----------------------------------------------			*/


  /**
   * Add key/value to HashMap,
   * replacing existing entry if value already exists.
   */
  static protected
  void
  putUniq  (HashMap	hm	,
	    Object	objKey	,
	    Object	objVal	)
  {
    if (hm.containsValue( objVal )) {
      /*(void)*/hm.remove( valueToKey( hm , objVal ) );
    }

    /*(void)*/hm.put( objKey , objVal );
  }


  /**
   * Add HashMap to HashMap,
   * replacing existing entries for which value already exists.
   */
  static protected
  void
  putAllUniq  (HashMap	hmAll	,
	       HashMap	hmAdd	)
  {
    Iterator	iter;
    Map.Entry	entry;

    for (iter = hmAdd.entrySet(  ).iterator(  ) ; iter.hasNext(  ) ;  ) {
      entry = (Map.Entry)iter.next(  );
      /*void*/putUniq( hmAll , entry.getKey(  ) , entry.getValue(  ) );
    }
  }


  static protected
  Object
  valueToKey  (HashMap	hm		,
	       Object	objValue	)
  {
    Iterator	iter;
    Map.Entry	entry;

    for (iter = hm.entrySet(  ).iterator(  ) ; iter.hasNext(  ) ;  ) {
      entry = (Map.Entry)iter.next(  );
      if (entry.getValue(  ).equals( objValue )) {
	return entry.getKey(  );				/*RETURN*/
      }
    }

    return null;						/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Class Protected Constants
 *--------------------------------------------------------------------------*/

 /* these are specific to this package */
  final static protected  HashMap	hmClassToNameComponent	=
							new HashMap(  );
  final static protected  HashMap	hmClassToNameProperty	=
							new HashMap(  );
  final static protected  HashMap	hmClassToNameParameter	=
							new HashMap(  );


/*----------------------------------------------------------------------------
 *						Class Protected Variables
 *--------------------------------------------------------------------------*/

  /* for Text and Text derived classes,
     should texts input and output
     be quoted/escaped and unquoted/unescaped by default? */
  static protected  boolean	mc_bProcessTexts;

  /*Note: this is actually intended to be constant,
    but need to be non-final for setup in static
  */
  static protected  String	mc_strClassPath;

 /* these may be added to by other packages */
  final static protected  HashMap	hmClassToNameAllComponent	=
							new HashMap(  );
  final static protected  HashMap	hmClassToNameAllProperty	=
							new HashMap(  );
  final static protected  HashMap	hmClassToNameAllParameter	=
							new HashMap(  );


/*----------------------------------------------------------------------------
 *						Class Initializers
 *--------------------------------------------------------------------------*/

  static
  {
    mc_strClassPath = Config.class.getName(  );
    mc_strClassPath = mc_strClassPath.substring(
		0 , mc_strClassPath.lastIndexOf( '.' ) );

    /*void*/putClassToName( hmClassToNameComponent ,
		ICalendar.class , Names.strVCalendar );
    /*void*/putClassToName( hmClassToNameComponent ,
		VAlarm.class , Names.strComp_VAlarm );
    /*void*/putClassToName( hmClassToNameComponent ,
		VEvent.class , Names.strComp_VEvent );
    /*void*/putClassToName( hmClassToNameComponent ,
		XComp.class , Names.strComp_X );
    /*void*/putClassToName( hmClassToNameComponent ,
		VTodo.class , Names.strComp_VTodo );
    /*void*/putClassToName( hmClassToNameComponent ,
		VJournal.class , Names.strComp_VJournal );
    /*void*/putClassToName( hmClassToNameComponent ,
		VFreeBusy.class , Names.strComp_VFreeBusy );
    /*void*/putClassToName( hmClassToNameComponent ,
		VTimeZone.class , Names.strComp_VTimeZone );
    /*void*/putClassToName( hmClassToNameComponent ,
		IANAComp.class , Names.strComp_IANA );
    /*void*/putClassToName( hmClassToNameProperty ,
		Duration.class , Names.strProp_Duration );
    /*void*/putClassToName( hmClassToNameProperty ,
		PercentComplete.class , Names.strProp_PercentComplete );
    /*void*/putClassToName( hmClassToNameProperty ,
		Priority.class , Names.strProp_Priority );
    /*void*/putClassToName( hmClassToNameProperty ,
		Repeat.class , Names.strProp_Repeat );
    /*void*/putClassToName( hmClassToNameProperty ,
		Sequence.class , Names.strProp_Sequence );
    /*void*/putClassToName( hmClassToNameProperty ,
		ProdId.class , Names.strProp_ProdId );
    /*void*/putClassToName( hmClassToNameProperty ,
		XProp.class , Names.strProp_X );
    /*void*/putClassToName( hmClassToNameProperty ,
		RelatedTo.class , Names.strProp_RelatedTo );
    /*void*/putClassToName( hmClassToNameProperty ,
		UID.class , Names.strProp_UID );
    /*void*/putClassToName( hmClassToNameProperty ,
		Version.class , Names.strProp_Version );
    /*void*/putClassToName( hmClassToNameProperty ,
		RequestStatus.class , Names.strProp_RequestStatus );
    /*void*/putClassToName( hmClassToNameProperty ,
		Action.class , Names.strProp_Action );
    /*void*/putClassToName( hmClassToNameProperty ,
		TZName.class , Names.strProp_TZName );
    /*void*/putClassToName( hmClassToNameProperty ,
		Comment.class , Names.strProp_Comment );
    /*void*/putClassToName( hmClassToNameProperty ,
		Contact.class , Names.strProp_Contact );
    /*void*/putClassToName( hmClassToNameProperty ,
		Description.class , Names.strProp_Description );
    /*void*/putClassToName( hmClassToNameProperty ,
		Location.class , Names.strProp_Location );
    /*void*/putClassToName( hmClassToNameProperty ,
		Summary.class , Names.strProp_Summary );
    /*void*/putClassToName( hmClassToNameProperty ,
		CalScale.class , Names.strProp_CalScale );
    /*void*/putClassToName( hmClassToNameProperty ,
		Class.class , Names.strProp_Class );
    /*void*/putClassToName( hmClassToNameProperty ,
		Method.class , Names.strProp_Method );
    /*void*/putClassToName( hmClassToNameProperty ,
		Status.class , Names.strProp_Status );
    /*void*/putClassToName( hmClassToNameProperty ,
		Transp.class , Names.strProp_Transp );
    /*void*/putClassToName( hmClassToNameProperty ,
		Categories.class , Names.strProp_Categories );
    /*void*/putClassToName( hmClassToNameProperty ,
		Resources.class , Names.strProp_Resources );
    /*void*/putClassToName( hmClassToNameProperty ,
		Geo.class , Names.strProp_Geo );
    /*void*/putClassToName( hmClassToNameProperty ,
		URL.class , Names.strProp_URL );
    /*void*/putClassToName( hmClassToNameProperty ,
		TZURL.class , Names.strProp_TZURL );
    /*void*/putClassToName( hmClassToNameProperty ,
		Attendee.class , Names.strProp_Attendee );
    /*void*/putClassToName( hmClassToNameProperty ,
		Organizer.class , Names.strProp_Organizer );
    /*void*/putClassToName( hmClassToNameProperty ,
		Completed.class , Names.strProp_Completed );
    /*void*/putClassToName( hmClassToNameProperty ,
		Created.class , Names.strProp_Created );
    /*void*/putClassToName( hmClassToNameProperty ,
		DTEnd.class , Names.strProp_DTEnd );
    /*void*/putClassToName( hmClassToNameProperty ,
		DTStamp.class , Names.strProp_DTStamp );
    /*void*/putClassToName( hmClassToNameProperty ,
		DTStart.class , Names.strProp_DTStart );
    /*void*/putClassToName( hmClassToNameProperty ,
		Due.class , Names.strProp_Due );
    /*void*/putClassToName( hmClassToNameProperty ,
		LastModified.class , Names.strProp_LastModified );
    /*void*/putClassToName( hmClassToNameProperty ,
		RecurrenceId.class , Names.strProp_RecurrenceId );
    /*void*/putClassToName( hmClassToNameProperty ,
		IANAProp.class , Names.strProp_IANA );
    /*void*/putClassToName( hmClassToNameProperty ,
		Attach.class , Names.strProp_Attach );
    /*void*/putClassToName( hmClassToNameProperty ,
		ExDate.class , Names.strProp_ExDate );
    /*void*/putClassToName( hmClassToNameProperty ,
		RDate.class , Names.strProp_RDate );
    /*void*/putClassToName( hmClassToNameProperty ,
		TZID.class , Names.strProp_TZID );
    /*void*/putClassToName( hmClassToNameProperty ,
		Trigger.class , Names.strProp_Trigger );
    /*void*/putClassToName( hmClassToNameProperty ,
		TZOffsetFrom.class , Names.strProp_TZOffsetFrom );
    /*void*/putClassToName( hmClassToNameProperty ,
		TZOffsetTo.class , Names.strProp_TZOffsetTo );
    /*void*/putClassToName( hmClassToNameProperty ,
		FreeBusy.class , Names.strProp_FreeBusy );
    /*void*/putClassToName( hmClassToNameProperty ,
		ExRule.class , Names.strProp_ExRule );
    /*void*/putClassToName( hmClassToNameProperty ,
		RRule.class , Names.strProp_RRule );
    /*void*/putClassToName( hmClassToNameParameter ,
		RelTypeParam.class , Names.strParam_RelType );
    /*void*/putClassToName( hmClassToNameParameter ,
		RelatedParam.class , Names.strParam_Related );
    /*void*/putClassToName( hmClassToNameParameter ,
		ValueParam.class , Names.strParam_Value );
    /*void*/putClassToName( hmClassToNameParameter ,
		XParam.class , Names.strParam_X );
    /*void*/putClassToName( hmClassToNameParameter ,
		AltRepParam.class , Names.strParam_AltRep );
    /*void*/putClassToName( hmClassToNameParameter ,
		CNParam.class , Names.strParam_CN );
    /*void*/putClassToName( hmClassToNameParameter ,
		CUTypeParam.class , Names.strParam_CUType );
    /*void*/putClassToName( hmClassToNameParameter ,
		DelFromParam.class , Names.strParam_DelFrom );
    /*void*/putClassToName( hmClassToNameParameter ,
		DelToParam.class , Names.strParam_DelTo );
    /*void*/putClassToName( hmClassToNameParameter ,
		DirParam.class , Names.strParam_Dir );
    /*void*/putClassToName( hmClassToNameParameter ,
		LanguageParam.class , Names.strParam_Language );
    /*void*/putClassToName( hmClassToNameParameter ,
		MemberParam.class , Names.strParam_Member );
    /*void*/putClassToName( hmClassToNameParameter ,
		PartStatParam.class , Names.strParam_PartStat );
    /*void*/putClassToName( hmClassToNameParameter ,
		RSVPParam.class , Names.strParam_RSVP );
    /*void*/putClassToName( hmClassToNameParameter ,
		RangeParam.class , Names.strParam_Range );
    /*void*/putClassToName( hmClassToNameParameter ,
		RoleParam.class , Names.strParam_Role );
    /*void*/putClassToName( hmClassToNameParameter ,
		SentByParam.class , Names.strParam_SentBy );
    /*void*/putClassToName( hmClassToNameParameter ,
		TZIDParam.class , Names.strParam_TZID );
    /*void*/putClassToName( hmClassToNameParameter ,
		IANAParam.class , Names.strParam_IANA );
    /*void*/putClassToName( hmClassToNameParameter ,
		EncodingParam.class , Names.strParam_Encoding );
    /*void*/putClassToName( hmClassToNameParameter ,
		FmtTypeParam.class , Names.strParam_FmtType );
    /*void*/putClassToName( hmClassToNameParameter ,
		FBTypeParam.class , Names.strParam_FBType );

    /*void*/putAllClassToName( hmClassToNameAllComponent ,
			       hmClassToNameComponent );
    /*void*/putAllClassToName( hmClassToNameAllProperty ,
			       hmClassToNameProperty );
    /*void*/putAllClassToName( hmClassToNameAllParameter ,
			       hmClassToNameParameter );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    /*void*/System.out.println( "# # " + Config.hmClassToNameAllParameter );
  }

}


/* Log:
 *  0.01  2003/10/29  slh
 *        adjust for ValueType -> Value
 *  0.00  2003/01/07 ... 2003/02/21, 2003/04/21 - 2003/04/23, 2003/07/30  slh
 *        create
 */
/*--Config.java-------------------------------------------------------------*/
