/*++Component.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Enumeration;
import  java.util.Vector;


/**
 * Base class for ICalendar components.
 *
 * Subclassing:
 * Override configComponent() to create and populate m_v{Comp|Prop}* with
 * the allowed components and properties.
 * configComponent() will be called from all the constructors.
 *
 * @author  slh
 * @version  0.20 2003/04/23 slh
 */
abstract public
class  Component
implements  Collectible
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  protected
  Component  (String	strName	)
  {
    if (strName == null) {
      throw new NullPointerException( "Component: Component()" +
		": strName (String) is null" );
    }
    m_strName = strName;

    m_properties = new Properties(  );
    m_components = new Components(  );

    /*void*/configComponent(  );
    try {
      /*void*/setupComponent(  );
    } catch (Exception	e	) {
      throw new InternalError( getName(  ) + ": Component(): " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getName  (		)
  {
    return m_strName;
  }


  public
  boolean
  isComplete  (		)
  {
    Enumeration		enum;

    if ((m_vCompOne != null || m_vCompOnePlus != null) &&
	m_components.size(  ) == 0) {
      return false;						/*RETUNR*/
    }
    if (m_vCompOne != null) {
      for (enum = m_vCompOne.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 != m_components.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }
    if (m_vCompOnePlus != null) {
      for (enum = m_vCompOnePlus.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 > m_components.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    if (m_vCompZeroOne != null) {
      for (enum = m_vCompZeroOne.elements(  ) ; enum.hasMoreElements(  ) ;  ) {
	if (1 < m_components.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    if ((m_vPropOne != null || m_vPropOnePlus != null) &&
	m_properties.size(  ) == 0) {
      return false;						/*RETUNR*/
    }
    if (m_vPropOne != null) {
      for (enum = m_vPropOne.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 != m_properties.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }
    if (m_vPropOnePlus != null) {
      for (enum = m_vPropOnePlus.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 > m_properties.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    if (m_vPropZeroOne != null) {
      for (enum = m_vPropZeroOne.elements(  ) ; enum.hasMoreElements(  ) ;  ) {
	if (1 < m_properties.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    return m_components.isComplete(  ) && m_properties.isComplete(  );
								/*RETURN*/
  }


  public
  boolean
  isSupported  (		)
  {
    return m_components.isSupported(  ) && m_properties.isSupported(  );
  }


  /**
   * @return
   * the components associated with this component.
   * Will never be null.
   */
  public
  Components
  getComponents  (		)
  {
    return m_components;
  }


  /**
   * Add a component to component.
   *
   * Adds component to this component
   * checking for component type and number.
   *
   * @exception	NullPointerException
   *   if component is null
   * @exception	InvalidComponentException
   *   if component type or number is not allowed
   */
  public
  void
  addComponent  (Component	component	)
  throws ICalendarException
  {
    if (component == null) {
      throw new NullPointerException( getName(  ) + ": addComponent()" +
		": component (Component) is null" );
    }

    if ((m_vCompOne == null ||
	 !ClassVector.contains( m_vCompOne , component.getClass(  ) )) &&
	(m_vCompOnePlus == null ||
	 !ClassVector.contains( m_vCompOnePlus , component.getClass(  ) )) &&
	(m_vCompZeroOne == null ||
	 !ClassVector.contains( m_vCompZeroOne , component.getClass(  ) )) &&
	(m_vCompZeroPlus == null ||
	 !ClassVector.contains( m_vCompZeroPlus , component.getClass(  )))) {
      throw new InvalidComponentException( getName(  ) + ": addComponent()" +
		": component not allowed: " + component.getName(  ) );
    }

    if (m_vCompOne != null &&
	ClassVector.contains( m_vCompOne , component.getClass(  ) ) &&
	0 != m_components.getCount( component.getClass(  ) ) ||
	m_vCompZeroOne != null &&
	ClassVector.contains( m_vCompZeroOne , component.getClass(  ) ) &&
	0 != m_components.getCount( component.getClass(  ) )) {
      throw new InvalidComponentException( getName(  ) + ": addComponent()" +
		": maximum of one instance allowed of component: " +
		component.getName(  ) );
    }

    /*void*/addAnyComponent( component );
  }


  /**
   * @return
   * the properties associated with this component.
   * Will never be null.
   */
  public
  Properties
  getProperties  (		)
  {
    return m_properties;
  }


  /**
   * Add a property to component.
   *
   * Adds property to this component
   * checking for property type and number.
   *
   * @exception	NullPointerException
   *   if property is null
   * @exception	InvalidPropertyException
   *   if property type or number is not allowed
   */
  public
  void
  addProperty  (Property	property	)
  throws ICalendarException
  {
    if (property == null) {
      throw new NullPointerException( getName(  ) + ": addProperty()" +
		": property (Property) is null" );
    }

    if ((m_vPropOne == null ||
	 !ClassVector.contains( m_vPropOne , property.getClass(  ) )) &&
	(m_vPropOnePlus == null ||
	 !ClassVector.contains( m_vPropOnePlus , property.getClass(  ) )) &&
	(m_vPropZeroOne == null ||
	 !ClassVector.contains( m_vPropZeroOne , property.getClass(  ) )) &&
	(m_vPropZeroPlus == null ||
	 !ClassVector.contains( m_vPropZeroPlus , property.getClass(  ) ))) {
      throw new InvalidPropertyException( getName(  ) + ": addProperty()" +
		": property not allowed: " + property.getName(  ) );
    }

    if (m_vPropOne != null &&
	ClassVector.contains( m_vPropOne , property.getClass(  ) ) &&
	0 != m_properties.getCount( property.getClass(  ) ) ||
	m_vPropZeroOne != null &&
	ClassVector.contains( m_vPropZeroOne , property.getClass(  ) ) &&
	0 != m_properties.getCount( property.getClass(  ) )) {
      throw new InvalidPropertyException( getName(  ) + ": addProperty()" +
		": maximum of one instance allowed of property: " +
		property.getName(  ) );
    }

    /*void*/addAnyProperty( property );
  }


  public
  String
  toString  (		)
  {
    return "BEGIN:" + m_strName + Strings.strLineTerm +
		m_properties +
		m_components +
		"END:" + m_strName + Strings.strLineTerm;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * allows subclasses to super.add
   */
  protected
  void
  addAnyComponent  (Component   component       )
  {
    if (component == null) {
      throw new NullPointerException( getName(  ) + ": addAnyComponent()" +
		": component (Component) is null" );
    }

    /*void*/m_components.put( component );
  }


  /**
   * allows subclasses to super.add
   */
  protected
  void
  addAnyProperty  (Property	property	)
  {
    if (property == null) {
      throw new NullPointerException( getName(  ) + ": addAnyProperty()" +
		": property (Property) is null" );
    }

    /*void*/m_properties.put( property );
  }


  /**
   * Configures component by populating m_v{Comp|Prop}*.
   */
  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( XComp.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


  protected
  void
  setupComponent  (		)
  throws InstantiationException, IllegalAccessException
  {
//???rm when all refs rm
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_strName never null after construction*/
  protected  String		m_strName		= null;
  /*Assert: m_properties never null after construction*/
  protected  Properties		m_properties		= null;
  /*Assert: m_components never null after construction*/
  protected  Components		m_components		= null;

  /**
   * Components that MUST occur exactly once.
   */
  protected  Vector		m_vCompOne		= null;
  /**
   * Components that MUST occur at least once and MAY occur more than once.
   */
  protected  Vector		m_vCompOnePlus		= null;
  /**
   * Components that are OPTIONAL but MAY NOT occur more than once.
   */
  protected  Vector		m_vCompZeroOne		= null;
  /**
   * Components that MAY occur more than once.
   */
  protected  Vector		m_vCompZeroPlus		= null;
  /**
   * Properties that MUST occur exactly once.
   */
  protected  Vector		m_vPropOne		= null;
  /**
   * Properties that MUST occur at least once and MAY occur more than once.
   */
  protected  Vector		m_vPropOnePlus		= null;
  /**
   * Properties that are OPTIONAL but MAY NOT occur more than once.
   */
  protected  Vector		m_vPropZeroOne		= null;
  /**
   * Properties that MAY occur more than once.
   */
  protected  Vector		m_vPropZeroPlus		= null;

}


/* Log:
 *  0.20  2003/01/07 ... 2003/02/12, 2003/04/16, 2003/04/23  slh
 *        (new year, new version...)
 *        (rm getClassMap(); start backing out setupProperty())
 *        addComponent/Property(): use class to id members
 *        addComponent/Property(): narrow throws from Exception
 *        getComponents/Properties(): rm throws
 *        use .class to get class
 *        getClassMap(), setupComponent(), m_hmNameToClass
 *  0.10  2002/11/12 - 2002/11/13, 2002/12/04, 2002/12/10  slh
 *        toString(): output final terminator
 *        implement ch in Collectible: isComplete(), isSupported()
 *        m_components, m_properites never null (after construction)
 *        table driven
 *  0.01  2001/11/20  slh
 *        change line term from \n to Strings.strLineTerminator
 *  0.00  2001/04/24 - 2001/04/25, 2001/05/01, 2001/05/09  slh
 *        create
 */
/*--Component.java----------------------------------------------------------*/
