/*++Collection.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;

import  java.util.Iterator;
import  java.util.NoSuchElementException;
import  java.util.Vector;


/**
 * Base class for groups of iCalendar components, properties or parameters.
 *
 * Warning: Iterator become invalid when the collection is changed.
 *
 * @author  slh
 * @version  0.20 2003/04/16 slh
 */
abstract public
class  Collection
implements  Collectible
{

/*----------------------------------------------------------------------------
 *						Inner Classes
 *--------------------------------------------------------------------------*/

private
class  EnumName
implements  Iterator
{

  public
  EnumName  (String	strName	)
  {
    if (strName == null) {
      throw new NullPointerException( getName(  ) + ": EnumName()" +
		": strName (String) is null" );
    }

    m_strName = strName;
    m_Index = 0;
  }


  public
  boolean
  hasNext  (		)
  {
    for ( ;
	 m_Index < m_vector.size(  ) &&
	   !m_strName.equals(
		((Collectible)m_vector.elementAt( m_Index )).getName(  ) ) ;
	 m_Index++) {
      ;		/* null statement */
    }

    return m_Index < m_vector.size(  );
  }


  public
  Object
  next  (		)
  throws NoSuchElementException
  {
    if (hasNext(  )) {
      return m_vector.elementAt( m_Index++ );
    } else {
      throw new NoSuchElementException(  );
    }
  }

  /**
    not supported
    @exception UnsupportedOperationException always thrown
   */
  public void remove() throws UnsupportedOperationException
  {
    throw new 
        UnsupportedOperationException("Can't remove a date from an event");
  }


  private  String	m_strName;
  private  int		m_Index;

}


private
class  EnumClass
implements  Iterator
{

  public
  EnumClass  (java.lang.Class	jlclass	)
  {
    if (jlclass == null) {
      throw new NullPointerException( getName(  ) + ": EnumClass()" +
		": jlclass (Class) is null" );
    }

    m_jlclass = jlclass;
    m_Index = 0;
  }


  public
  boolean
  hasNext  (		)
  {
    java.lang.Class	jlclass;

    for ( ;
	 m_Index < m_vector.size(  ) &&
	 /* null check only needed to make propery type */
	 null != (jlclass = m_vector.elementAt( m_Index ).getClass(  )) &&
	 !(m_jlclass.isAssignableFrom( jlclass ) ||
	   jlclass.isAssignableFrom( m_jlclass )) ;
	 m_Index++) {
      ;		/* null statement */
    }

    return m_Index < m_vector.size(  );
  }


  public
  Object
  next(		)
  throws NoSuchElementException
  {
    /*Note: using hasMoreElements() w/incremening to position cursor*/
    if (hasNext(  )) {
      return m_vector.elementAt( m_Index++ );
    } else {
      throw new NoSuchElementException(  );
    }
  }

  /**
    not supported
    @exception UnsupportedOperationException always thrown
   */
  public void remove() throws UnsupportedOperationException
  {
    throw new UnsupportedOperationException();
  }

  private  java.lang.Class	m_jlclass;
  private  int			m_Index;

}


/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a collection.
   */
  protected
  Collection  (		)
  {
    this( null );
  }


  /**
   * Create a collection with given name.
   */
  protected
  Collection  (String	strName	)
  {
    m_vector = new Vector(  );

    m_strName = strName != null ? strName : "Collection";
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getName  (		)
  {
    return m_strName;
  }


  public
  boolean
  isComplete  (		)
  {
    int		idx;

    for (idx = 0 ; idx < m_vector.size(  ) ; idx++) {
      if (!((Collectible)m_vector.elementAt( idx )).isComplete(  )) {
	return false;						/*RETURN*/
      }
    }

    return true;						/*RETURN*/
  }


  public
  boolean
  isSupported  (		)
  {
    int		idx;

    for (idx = 0 ; idx < m_vector.size(  ) ; idx++) {
      if (!((Collectible)m_vector.elementAt( idx )).isSupported(  )) {
	return false;						/*RETURN*/
      }
    }

    return true;						/*RETURN*/
  }


  /**
   * Enumerate members.
   */
  public
  Iterator
  elements  (		)
  {
    return m_vector.iterator(  );
  }


  /**
   * Enumerate members with matching name.
   */
  public
  Iterator
  get  (String	strName	)
  {
    if (strName == null) {
      throw new NullPointerException( getName(  ) + ": get(String)" +
		": strName (String) is null" );
    }

    return new EnumName( strName );
  }


  /**
   * Enumerate members with matching class.
   *
   * Matching meaning one (either) is assignable to the other.
   */
  public
  Iterator
  get  (java.lang.Class	jlclass	)
  {
    if (jlclass == null) {
      throw new NullPointerException( getName(  ) + ": get(Class)" +
		": jlclass (Class) is null" );
    }

    return new EnumClass( jlclass );
  }


  /**
   * Retrieve first member with matching name.
   */
  public
  Collectible
  getFirst  (String	strName	)
  {
    /* get() checks/throws for null */
    Iterator		enum		= get( strName );

    return (Collectible)
	(enum.hasNext(  ) ? enum.next(  ) : null);
  }


  /**
   * Retrieve first member with matching Class.
   *
   * Matching meaning one (either) is assignable to the other.
   */
  public
  Collectible
  getFirst  (java.lang.Class	jlclass	)
  {
    /* get() checks/throws for null */
    Iterator		enum		= get( jlclass );

    return (Collectible)
	(enum.hasNext(  ) ? enum.next(  ) : null);
  }


  /**
   * Get count of members with matching name.
   */
  public
  int
  getCount  (String	strName	)
  {
    Iterator		enum;
    int			count		= 0;

    /* get() checks/throws for null */

    for (enum = get( strName ) ;
	 enum.hasNext(  ) ;
	 enum.next(  )) {
      count++;
    }

    return count;
  }


  /**
   * Get count of members with matching class.
   *
   * Matching meaning one (either) is assignable to the other.
   */
  public
  int
  getCount  (java.lang.Class	jlclass	)
  {
    Iterator		enum;
    int			count		= 0;

    /* get() checks/throws for null */

    for (enum = get( jlclass ) ;
	 enum.hasNext(  ) ;
	 enum.next(  )) {
      count++;
    }

    return count;
  }


  /**
   * Is collection empty?
   */
  public
  boolean
  isEmpty  (		)
  {
    return m_vector.size(  ) == 0;
  }


/*???implement
  keys() 
   Returns an enumeration of the keys in this dictionary. 
*/


  /**
   * Add to collection.
   */
  public
  void  put  (Collectible	collectible	)
  {
    if (collectible == null) {
      throw new NullPointerException( getName(  ) + ": put()" +
		": collectible (Collectible) is null" );
    }

    /*void*/m_vector.addElement( collectible );
  }


  /**
   * Remove from collection.
   */
  public
  boolean
  remove  (Collectible	collectible	)
  {
    if (collectible == null) {
      throw new NullPointerException( getName(  ) + ": remove()" +
		": collectible (Collectible) is null" );
    }

    return m_vector.removeElement( collectible );
  }


  /**
   * Get number of members.
   */
  public
  int
  size  (		)
  {
    return m_vector.size(  );
  }


  /**
   * Render string representation.
   */
  public
  String
  toString  (		)
  {
    return m_vector.toString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Private Variables
 *--------------------------------------------------------------------------*/

  protected  String	m_strName		= null;
  /* m_vector created in constructor, so always exists in use */
  protected  Vector	m_vector		= null;

}


/* Log:
 *  0.20  2003/02/05, 2003/04/16  slh
 *        (new year, new version...)
 *        add EnumClass: add get(Class), getFirst(Class), redo getCount(Class)
 *  0.10  2002/10/30, 2002/12/04  slh
 *        implement ch in Collectible: isComplete(), isSupported()
 *        getCount(Class)
 *        redo constructors
 *  0.01  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        remove(): thrown exception msg incorrect (cnp error)
 *        javadoc comments
 *  0.00  2001/05/01 - 2001/05/02, 2001/05/09  slh
 *        create
 */
/*--Collection.java---------------------------------------------------------*/
