/*++Collectible.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Collectible: interface for objects to be put in a Collection.
 *
 * @author  slh
 * @version  0.10 2002/12/04 slh
 */
public
interface  Collectible
{

/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Name of this object.
   *
   * @return
   * iCalendar name when object represents an iCalendar object
   * (which is usually the case);
   * otherwise name probably does not have any significance.
   */
  public
  String
  getName  (		);


  /**
   * Is object (including its parts) complete.
   *
   * @return
   * true if an iCalendar object and
   * its state, including its parts (components, properties and/or parameters)
   * represent a valid iCalendar object;
   * true if a container and
   * the state of its members represent valid iCalendar objects.
   */
  public
  boolean
  isComplete  (		);


  /**
   * Is object (including its part) supported.
   *
   * @return
   * true if an iCalendar object and
   * it, including its parts (components, properties and/or parameters)
   * is a supported iCalendar object;
   * true if a container and
   * its members are supported iCalendar objects.
   * Only objects that should return false are those that are
   * subclasses of the the Unsup* classes.
   */
  public
  boolean
  isSupported  (		);

}


/* Log:
 *  0.10  2002/12/04  slh
 *        isComplete(), isSupported()
 *  0.00  2001/05/01  slh
 *        create
 */
/*--Collectible.java--------------------------------------------------------*/
