/*++ClassVector.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * Extends Vector to hold and do specific processing for Class objects.
 *
 * @author  slh
 * @version  0.00 2003/04/16 slh
 */
class  ClassVector
extends  Vector
{

/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Determines if Vector contains a matching Class.
   *
   * Matching meaning one (either) is assignable from the other;
   * rather than using equal().
   *
   * Using this until all appropriate new'ings can be changed to use
   * this class.
   */
  static public
  boolean
  contains  (Vector	vector	,
	     Object	object	)
  {
    Object	elementData[];
    int		elementCount;
    int		idx;

    elementData = vector.toArray(  );
    elementCount = vector.size(  );
    for (idx = 0 ; idx < elementCount ; idx++) {
      if (((java.lang.Class)elementData[idx]).isAssignableFrom(
			(java.lang.Class)object ) ||
	  ((java.lang.Class)object).isAssignableFrom(
			(java.lang.Class)elementData[idx] )) {
	return true;						/*RETURN*/
      }
    }

    return false;						/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Determines if Vector contains a matching Class.
   *
   * Matching meaning one (either) is assignable from the other;
   * rather than using equal().
   */
  public
  boolean
  contains  (Object	object	)
  {
    int		idx;

    for (idx = 0 ; idx < elementCount ; idx++) {
      if (((java.lang.Class)elementData[idx]).isAssignableFrom(
			(java.lang.Class)object ) ||
	  ((java.lang.Class)object).isAssignableFrom(
			(java.lang.Class)elementData[idx] )) {
	return true;						/*RETURN*/
      }
    }

    return false;						/*RETURN*/
  }

}


/* Log:
 *  0.00  2003/04/16  slh
 *        create
 */
/*--ClassVector.java--------------------------------------------------------*/
