/*++Class.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar CLASS property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.3 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	"PUBLIC"
 *   allowed:	"PUBLIC", "PRIVATE", "CONFIDENTIAL", iana-token, x-name
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/22 slh
 */
public
class  Class
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CLASS property, set to default.
   */
  public
  Class  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CLASS property set to supplied value.
   */
  public
  Class  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a CLASS property set to supplied value.
   */
  public
  Class  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Class;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put(
		new Integer( PUBLIC ) , Names.strValue_Public );
    /*(void)*/m_hmValue.put(
		new Integer( PRIVATE ) , Names.strValue_Private );
    /*(void)*/m_hmValue.put(
		new Integer( CONFIDENTIAL ) , Names.strValue_Confidential );
    /*(void)*/m_hmValue.put( new Integer( IANATOKEN ) , null );
    /*(void)*/m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_Public;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	PUBLIC		= 1;
  final static public  int	PRIVATE		= 2;
  final static public  int	CONFIDENTIAL	= 3;

}


/* Log:
 *  0.10  2003/03/05, 2003/04/22  slh
 *        rm main()
 *        redo constructors
 *        configEnum(): drop set(), setEnum()
 *        getCalendarName()
 *  0.00  2001/04/24 - 2001/04/25, 2001/05/02, 2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--Class.java--------------------------------------------------------------*/
