/*++Categories.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar CATEGORIES property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.2 [2445]
 *   occurs:	VEVENT (0+)
 *   datatypes:	TEXT (1+)
 *   default:	---
 *   allowed:	---
 *   params:	LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Categories
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CATEGORIES property unset.
   */
  public
  Categories  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CATEGORIES property set to supplied value.
   */
  public
  Categories  (String	strValues	)
  {
    super( getCalendarName(  ) , strValues );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Categories;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/15  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        configProperty()
 *  0.01  2002/11/06  slh
 *        redo constructors, addParameter()
 *        comments
 *  0.00  2001/05/15  slh
 *        create
 */
/*--Categories.java---------------------------------------------------------*/
