/*++CalScale.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar CALSCALE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.7.1 [2445]
 *   occurs:	VCALENDAR (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	"GREGORIAN"
 *   allowed:	"GREGORIAN", iana-token
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/03/05 slh
 */
public
class  CalScale
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CALSCALE property, set to default.
   */
  public
  CalScale  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CALSCALE property set to supplied value.
   */
  public
  CalScale  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a CALSCALE property set to supplied value.
   */
  public
  CalScale  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_CalScale;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put(
		new Integer( GREGORIAN ) , Names.strValue_Gregorian );
    /*(void)*/m_hmValue.put( new Integer( IANATOKEN ) , null );

    m_strDefault = Names.strValue_Gregorian;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	GREGORIAN	= 1;

}


/* Log:
 *  0.10  2003/03/05  slh
 *        redo constructors
 *        configEnum(): drop set(), setEnum()
 *        getCalendarName()
 *  0.00  2001/04/24 - 2001/04/25  slh
 *        create
 */
/*--CalScale.java-----------------------------------------------------------*/
