/*++CalAddressProp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;



/**
 * CalAddressProp: base class for ICalendar MAILTO-URI-valued properties
 * (rfc2445 4.3.3).
 *
 * @author slh
 * @version 0.00 2001/05/14 slh
 */
abstract public
class  CalAddressProp
extends  URIProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  protected
  CalAddressProp  (String	strName	)
  {
    super( strName );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (String	strValue	)
  throws Exception
  {
    String	strComp;

    /*Note: letting one of the first two calls throw for a null*/

    /* to check format */
    new java.net.URL( strValue );

    strComp = strValue.substring( 0 , mc_strProtocol.length(  ) );
    if (!strComp.equalsIgnoreCase( mc_strProtocol )) {
      throw new IllegalArgumentException(
		getName(  ) + ": protocol must be Mailto:" );
    }

    super.set( strValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

    final static protected  String	mc_strProtocol		= "mailto";

}


/* Log:
 *  0.00  2001/05/14  slh
 *        create
 */
/*--CalAddressProp.java-----------------------------------------------------*/
