/*++CUTypeParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar CUTYPE (Calendar User TYPE) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.3 [2445]
 *   occurs:	<CAL-ADDRESS-valued properties> (1)
 *   datatypes:	TEXT (1)
 *   default:	"INDIVIDUAL"
 *   allowed:	"INDIVIDUAL", "GROUP", "RESOURCE", "ROOM", "UNKNOWN",
 *              iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/21 slh
 */
public
class  CUTypeParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CUTYPE parameter set to default.
   */
  public
  CUTypeParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CUTYPE parameter set to supplied string value.
   */
  public
  CUTypeParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a CUTYPE parameter set to supplied id value.
   */
  public
  CUTypeParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_CUType;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( INDIVIDUAL ) , Names.strValue_Individual );
    m_hmValue.put( new Integer( GROUP ) , Names.strValue_Group );
    m_hmValue.put( new Integer( RESOURCE ) , Names.strValue_Resource );
    m_hmValue.put( new Integer( ROOM ) , Names.strValue_Room );
    m_hmValue.put( new Integer( UNKNOWN ) , Names.strValue_Unknown );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_Individual;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	INDIVIDUAL	= 1;
  final static public  int	GROUP		= 2;
  final static public  int	RESOURCE	= 3;
  final static public  int	ROOM		= 4;
  final static public  int	UNKNOWN		= 5;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    CUTypeParam	cutypeparam	= new CUTypeParam(  );

    /*void*/System.out.println( cutypeparam );

    try {
      /*void*/cutypeparam.set( "GROUP" );
      /*void*/System.out.println( cutypeparam );

      /*void*/cutypeparam.set( RESOURCE );
      /*void*/System.out.println( cutypeparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( cutypeparam.get(  ) );
    /*void*/System.out.println( cutypeparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cutypeparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cutypeparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( cutypeparam );
  }

}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from EnumParam (rather than UnsupParam) based on RelTypeParam
 *  0.00  2001/05/15  slh
 *        create
 */
/*--CUTypeParam.java--------------------------------------------------------*/
