/*++CNParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar CN (Common Name) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.2 [2445]
 *   occurs:	<CAL-ADDRESS-valued properties> (1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/21 slh
 */
public
class  CNParam
extends  TextParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CN parameter, unset.
   */
  public
  CNParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a CN parameter set to supplied string value.
   */
  public
  CNParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_CN;
  }

}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from TextParam (rather than UnsupParam)
 *  0.00  2001/05/15  slh
 *        create
 */
/*--CNParam.java------------------------------------------------------------*/
