/*++BoundedIntegerParam.java++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for bounded INTEGER-valued parameters.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	derived from 4.3.8 Integer
 *   allowed:	---
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
abstract public
class  BoundedIntegerParam
extends  IntegerParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a BoundedInteger parameter w/o bounds.
   */
  public
  BoundedIntegerParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a BoundedInteger parameter with indicated bounds.
   * A bound may be null, indicating no bound.
   */
  public
  BoundedIntegerParam  (String	strName	,
			Integer	IMin	,
			Integer	IMax	)
  {
    super( strName );

    m_IMin = IMin;
    m_IMax = IMax;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (int	iValue	)
  {
    if (m_IMin != null && iValue < m_IMin.intValue(  ) ||
	m_IMax != null && iValue > m_IMax.intValue(  ))
    {
      throw new IllegalArgumentException( getName(  ) +
		": value: " + iValue +
		" out of range: " +
		(m_IMin != null ? m_IMin.toString(  ) : "<unbounded>") +
		" - " +
		(m_IMax != null ? m_IMax.toString(  ) : "<unbounded>") );
    }

    m_IValue = new Integer( iValue );
  }


  /*Note: super.set(Integer) goes through super.set(int)*/
  /*Note: super.set(String) goes through super.set(int)*/


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_IMin, m_IMax never change after construction;
    or at least not here (should be ok to do so in a subclass, if needed)
  */
  protected  Integer	m_IMin		= null;
  protected  Integer	m_IMax		= null;

}


/* Log:
 *  0.00  2002/10/30, 2002/11/06  slh
 *        create
 */
/*--BoundedIntegerParam.java------------------------------------------------*/
