/*++BooleanParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * Base class for ICalendar BOOLEAN-valued parameters.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.3.2 [2445]
 *   allowed:	"TRUE", "FALSE"
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/02 slh
 */
abstract public
class  BooleanParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a BOOLEAN parameter unset.
   */
  protected
  BooleanParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a BOOLEAN parameter set to supplied value.
   */
  protected
  BooleanParam  (String	strName		,
		 String	strValue	)
  {
    super( strName , strValue );
  }


  /**
   * Create a BOOLEAN parameter set to supplied value.
   */
  protected
  BooleanParam  (String	strName	,
		 int	iValue	)
  {
    super( strName , iValue );
  }


  /**
   * Create a BOOLEAN parameter set to supplied value.
   */
  protected
  BooleanParam  (String		strName	,
		 boolean	bValue	)
  {
    super( strName );

    try {
      /*void*/set( bValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Set value by boolean.
   */
  public
  void
  set  (boolean	bValue	)
  throws Exception
    {
    /*void*/super.set( bValue ? TRUE : FALSE );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( TRUE ) , Names.strValue_True );
    m_hmValue.put( new Integer( FALSE ) , Names.strValue_False );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	TRUE		=  1;
  final static public  int	FALSE		=  2;


}


/* Log:
 *  0.00  2002/10/29 ... 2002/11/06, 2002/11/13, 2002/12/02  slh
 *        create
 */
/*--BooleanParam.java-------------------------------------------------------*/
