/*++Attendee.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar ATTENDEE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.4.1 [2445]
 *   occurs:	VEVENT (0+)
 *   datatypes:	CAL-ADDRESS (1)
 *   default:	---
 *   allowed:	---
 *   params:	CUTYPE(0-1), MEMBER(0-1), ROLE(0-1), PARTSTAT(0-1),
 *		RSVP(0-1), DELEGATED-TO(0-1),
 *		DELEGATED-FROM(0-1), SENTBY(0-1), CN(0-1), DIR(0-1),
 *		LANGUAGE(0-1)
 *              xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Attendee
extends  CalAddressProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ATTENDEE property, unset.
   */
  public
  Attendee  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a ATTENDEE property set to supplied value.
   */
  public
  Attendee  (String	strValue	)
  {
    super( getCalendarName(  ) );

    try {
      /*void*/set( strValue );
    } catch (IllegalArgumentException	e	) {
      throw e;
    } catch (Exception	e	) {
      throw new IllegalArgumentException( getName(  ) + ": " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Attendee;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( CUTypeParam.class );
    m_vParamZeroOne.add( MemberParam.class );
    m_vParamZeroOne.add( RoleParam.class );
    m_vParamZeroOne.add( PartStatParam.class );
    m_vParamZeroOne.add( RSVPParam.class );
    m_vParamZeroOne.add( DelToParam.class );
    m_vParamZeroOne.add( DelFromParam.class );
    m_vParamZeroOne.add( SentByParam.class );
    m_vParamZeroOne.add( CNParam.class );
    m_vParamZeroOne.add( DirParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.00  2001/05/15  slh
 *        create
 */
/*--Attendee.java-----------------------------------------------------------*/
