/*++Action.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar ACTION property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.6.1 [2445]
 *   occurs:	VALARM (1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"AUDIO", "DISPLAY", "EMAIL", "PROCEDURE", iana-token, x-name
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00a 2003/10/29 slh
 */
public
class  Action
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ACTION property, unset.
   */
  public
  Action  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a ACTION property set to supplied value.
   */
  public
  Action  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a ACTION property set to supplied value.
   */
  public
  Action  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Action;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put( new Integer( AUDIO ) , Names.strValue_Audio );
    /*(void)*/m_hmValue.put(
		new Integer( DISPLAY ) , Names.strValue_Display );
    /*(void)*/m_hmValue.put( new Integer( EMAIL ) , Names.strValue_EMail );
    /*(void)*/m_hmValue.put(
		new Integer( PROCEDURE ) , Names.strValue_Procedure );
    /*(void)*/m_hmValue.put( new Integer( IANATOKEN ) , null );
    /*(void)*/m_hmValue.put( new Integer( XNAME ) , null );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	AUDIO		=  1;
  final static public  int	DISPLAY		=  2;
  final static public  int	EMAIL		=  3;
  final static public  int	PROCEDURE	=  4;

}


/* Log:
 *  0.00a 2003/10/29  slh
 *        comments
 *  0.00  2003/02/19  slh
 *        create
 */
/*--Action.java-------------------------------------------------------------*/
