/*++VRight.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;


/**
 * CAP VRIGHT component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.4 [CAP/09]
 *   comps:	none
 *   props:	PERMISSION(1+),
 *		GRANT(0+), DENY(0+), SCOPE(0+), RESTRICTION(0+),
 *		iana-prop(0+), x-prop(0+)
 *   Note: either GRANT or DENY must occur at least once.
 *
 * ``Conformance: This property can be specified in "VRIGHT" components,
 *   but only when the "PERMISSION" property is set to "CREATE", "MODIFY",
 *   or "*" property value.''
 * </PRE>
 *
 * @author  slh
 * @version  0.01 2003/01/28 slh
 */
public
class  VRight
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VRIGHT.
   */
  public
  VRight  (		)
  {
    super( Names.strComp_VRight );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    Permission	permission;

    if (0 == m_properties.getCount( Names.strProp_Deny ) &&
	0 == m_properties.getCount( Names.strProp_Grant )) {
      return false;						/*RETURN*/
    }

    /* if a RESTRICTION is present... */
    if (0 != m_properties.getCount( Names.strProp_Restriction )) {
      permission =
		(Permission)m_properties.getFirst( Names.strProp_Permission );
      /* if a PERMISSION is not present or
	 it is not CREATE, MODIFY or ALL... */
      if (permission == null ||
	  permission.getEnum(  ) != Permission.CREATE &&
	  permission.getEnum(  ) != Permission.MODIFY &&
	  permission.getEnum(  ) != Permission.ALL) {
	return false;						/*RETURN*/
      }
    }

    return super.isComplete(  );				/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding Component.configComponent()
    which is called in Component.Component(*).
  */
  protected
  void
  configComponent  (		)
  {
    m_vPropOnePlus = new Vector(  );
    /*void*/m_vPropOnePlus.add( Permission.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Grant.class );
    /*void*/m_vPropZeroPlus.add( Deny.class );
    /*void*/m_vPropZeroPlus.add( Scope.class );
    /*void*/m_vPropZeroPlus.add( Restriction.class );
    /*void*/m_vPropZeroPlus.add( IANAProp.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VRight	vright		= new VRight(  );
    Permission	permission	= new Permission( Names.strValue_Create );
    Grant	grant		= new Grant( "slh@cac.washington.edu" );
    Deny	deny		= new Deny( "*" );
    Scope	scope		= new Scope( "SELECT * FROM VEVENT" );
    Restriction	restriction	= new Restriction( "SELECT * FROM VTODO" );
    IANAProp	ianaprop	= new IANAProp( "NEWIANAPROP" , "its value" );
    XProp	xprop		= new XProp( "X-SLH-PROP" , "test prop" );

    /*void*/System.out.println( "isComplete: " + vright.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vright.isSupported(  ) );
    /*void*/System.out.println( vright );

    try {
      /*void*/vright.addProperty( permission );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vright.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vright.isSupported(  ) );
    /*void*/System.out.println( vright );

    try {
      /*void*/vright.addProperty( grant );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vright.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vright.isSupported(  ) );
    /*void*/System.out.println( vright );

    try {
      /*void*/vright.addProperty( deny );
      /*void*/vright.addProperty( scope );
      /*void*/vright.addProperty( restriction );
      /*void*/vright.addProperty( ianaprop );
      /*void*/vright.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vright.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vright.isSupported(  ) );
    /*void*/System.out.println( vright );

    /* invalid permission-restriction combo */
    try {
      /*void*/permission.set( Names.strValue_Search );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vright.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vright.isSupported(  ) );
    /*void*/System.out.println( vright );

  }

}


/* Log:
 *  0.01  2003/01/28  slh
 *        (new year, new version...)
 *        use .class to get class
 *  0.00  2002/11/12 - 2002/11/13, 2002/12/02 - 2002/12/03, 2002/12/11  slh
 *        create
 */
/*--VRight.java-------------------------------------------------------------*/
