/*++VReply.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.Sequence;
import  edu.washington.cac.calendar.icalendar.TZID;
import  edu.washington.cac.calendar.icalendar.UID;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;

import  edu.washington.cac.calendar.icalendar.XParam;		/* for main */


/**
 * CAP VREPLY component.
 *
 * Can represent a generic VREPLY (no restrictions) or
 * a command-specific VREPLY (contents restricted command-allowed members).
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.5, 10 [CAP-09+]
 *   comps:	any (0+)
 *   props:	any (0+)
 * </PRE>
 *
 * Command response replies:
 *   NONE	(generic/unrestricted)
 *   ABORT	(no components)
 *		REQUEST-STATUS(1), x-prop(0+)
 *   CONTINUE	(no components)
 *		REQUEST-STATUS(1), x-prop(0+)
 *   CREATE	(no components)
 *		*CALID(1), CARID(1), UID(1), QUERYID(1), TZID(1), SEQUENCE(1),
 *		  XID(1)???*,
 *		REQUEST-STATUS(1),
 *		x-prop(0+)
 *   DELETE	(no components)
 *		*CALID(1), CARID(1), UID(1), QUERYID(1), TZID(1), SEQUENCE(1),
 *		  XID(1)???*,
 *		REQUEST-STATUS(1),
 *		x-prop(0+)???
 *   GENERATE-UID
 *		(no components)
 *		UID(0+),
 *		REQUEST-STATUS(1),
 *		x-prop(0+)???
 *   GET-CAPABILITY
 *		(no components)
 *		CAP-VERSION(1), CAR-LEVEL(1), COMPONENTS(1),
 *		STORES-EXPANDED(1), MAXDATE(1), MINDATE(1),
 *		ITIP-VERSION(1), MAX-COMP-SIZE(1), MULTIPART(1),
 *		QUERY-LEVEL(1),
 *		RECUR-ACCEPTED(1), RECUR-EXPAND(1), RECUR-LIMIT(1),
 *		iana-prop(0+), x-prop(0+)
 *   IDENTIFY	REQUEST-STATUS(1)
 *   MODIFY	???
 *   MOVE	(no components)
 *		*CALID(1), CARID(1), UID(1), QUERYID(1), TZID(1), SEQUENCE(1),
 *		  XID(1)???*,
 *		REQUEST-STATUS(1),
 *		x-prop(0+)???
 *   REPLY	n/a
 *   SEARCH	???
 *   SET-LOCALE	(no components)
 *		REQUEST-STATUS(1), x-prop(0+)???
 *   TIMEOUT	(no components)
 *		REQUEST-STATUS(1), x-prop(0+)
 *
 * *only one of these ids may actually occur*
 *
 * @author  slh
 * @version  0.01 2003/04/28 slh
 */
public
class  VReply
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a basic VREPLY component.
   */
  public
  VReply  (		)
  {
    this( Cmd.NONE );
  }


  /*Note: this is the base constructor*/
  /**
   * Create a basic VREPLY of indicated CMD type.
   */
  public
  VReply  (String	strType	)
  {
    super( getCalendarName(  ) );

    /*void*/setType( strType );
  }


  /* this is the base constructor */
  /**
   * Create a basic VREPLY of indicated CMD type.
   */
  public
  VReply  (int	iType	)
  {
    super( getCalendarName(  ) );

    /*void*/setType( iType );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VReply;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    switch (m_iType) {
    case Cmd.ABORT:
    case Cmd.CONTINUE:
      /* no additional constraints */
      break;
    case Cmd.CREATE:
//???check that only one of id props exists; combine w/others?
      break;
    case Cmd.DELETE:
//???check that only one of id props exists; combine w/others?
      break;
    case Cmd.GENERATEUID:
    case Cmd.GETCAPABILITY:
      /* no additional constraints */
      break;
    case Cmd.IDENTIFY:
      /* should not be used */
      break;
    case Cmd.MODIFY:
//???
      break;
    case Cmd.MOVE:
//???check that only one of id props exists; combine w/others?
      break;
    case Cmd.REPLY:
      /* should not be used */
      break;
    case Cmd.SEARCH:
//???
      break;
    case Cmd.SETLOCALE:
    case Cmd.TIMEOUT:
      /* no additional constraints */
      break;
    case Cmd.NONE:
    default:
      /* do nothing */
      break;
    }

    return super.isComplete(  );				/*RETURN*/
  }


  public
  void
  setType  (String	strType	)
  {
    /*void*/setType( checkType( strType ) );
  }


  /*Note: base method */
  public
  void
  setType  (int	iType	)
  {
    m_iType = checkType( iType );

    /*void*/configComponent( m_iType );
    try {
      /*void*/setupComponent(  );
    } catch (Exception	e	) {
      throw new InternalError( getName(  ) + ": " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    /* do nothing - as using configComponent(int) */
  }


  protected
  void
  configComponent  (int	iType	)
  {
    switch (iType) {
    case Cmd.ABORT:
    case Cmd.CONTINUE:
    case Cmd.CREATE:
    case Cmd.DELETE:
    case Cmd.GENERATEUID:
    case Cmd.GETCAPABILITY:
    case Cmd.MOVE:
    case Cmd.SETLOCALE:
    case Cmd.TIMEOUT:
      m_vPropOne = new Vector(  );
      m_vPropZeroPlus = new Vector(  );
      break;
    case Cmd.IDENTIFY:
      m_vPropOne = new Vector(  );
      break;
    case Cmd.MODIFY:
//???
      break;
    case Cmd.REPLY:
      /* should not be used */
      break;
    case Cmd.SEARCH:
//???
      break;
    case Cmd.NONE:
    default:
      /* do nothing */
      break;
    }

    switch (iType) {
    case Cmd.ABORT:
    case Cmd.CONTINUE:
      /*void*/m_vPropOne.add( RequestStatus.class );
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.CREATE:
    case Cmd.DELETE:
    case Cmd.MOVE:
//???assuming these types actually the same for now, but curr defs are not
//???(recheck later; if not, other parts will need changing also
      /* only one of these should actually exist, enforced in isComplete() */
      /*void*/m_vPropOne.add( CalId.class );
      /*void*/m_vPropOne.add( CARID.class );
      /*void*/m_vPropOne.add( UID.class );
      /*void*/m_vPropOne.add( QueryId.class );
      /*void*/m_vPropOne.add( TZID.class );
      /*void*/m_vPropOne.add( Sequence.class );
/*???
   created-id    = ( calid / carid / uid / queryid /
                     tzid / sequence / x-id)
   deleted-id    = ( calid / carid / uid / uid dtstamp
                  / queryid / tzid / sequence / x-id )
           move-id    =  ( calid / carid / uid / uid dtstamp
                          / queryid / tzid / sequence / x-id)
*/
      /*void*/m_vPropOne.add( RequestStatus.class );
//???
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.GENERATEUID:
      /*void*/m_vPropZeroPlus.add( UID.class );
      /*void*/m_vPropOne.add( RequestStatus.class );
//???
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.GETCAPABILITY:
      /*void*/m_vPropOne.add( CAPVersion.class );
      /*void*/m_vPropOne.add( CARLevel.class );
      /*void*/m_vPropOne.add( Components.class );
      /*void*/m_vPropOne.add( StoresExpanded.class );
      /*void*/m_vPropOne.add( MaxDate.class );
      /*void*/m_vPropOne.add( MinDate.class );
      /*void*/m_vPropOne.add( ITIPVersion.class );
      /*void*/m_vPropOne.add( MaxCompSize.class );
      /*void*/m_vPropOne.add( MultiPart.class );
      /*void*/m_vPropOne.add( QueryLevel.class );
      /*void*/m_vPropOne.add( RecurAccepted.class );
      /*void*/m_vPropOne.add( RecurExpand.class );
      /*void*/m_vPropOne.add( RecurLimit.class );
      /*void*/m_vPropZeroPlus.add( IANAProp.class );
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.IDENTIFY:
      /*void*/m_vPropOne.add( RequestStatus.class );
      break;
    case Cmd.MODIFY:
//???
      break;
    case Cmd.REPLY:
      /* should not be used */
      break;
    case Cmd.SEARCH:
//???
      m_vCompZeroPlus = new Vector(  );
      m_vCompZeroPlus.add( Component.class );

      m_vPropZeroPlus = new Vector(  );
      m_vPropZeroPlus.add( Property.class );
      break;
    case Cmd.SETLOCALE:
      /*void*/m_vPropOne.add( RequestStatus.class );
//???
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.TIMEOUT:
      /*void*/m_vPropOne.add( RequestStatus.class );
      /*void*/m_vPropZeroPlus.add( XProp.class );
      break;
    case Cmd.NONE:
    default:
      m_vCompZeroPlus = new Vector(  );
      m_vCompZeroPlus.add( Component.class );

      m_vPropZeroPlus = new Vector(  );
      m_vPropZeroPlus.add( Property.class );
      break;
    }

//???if all have xprops, check for vPropZeroPlus being non-null and add here
  }


  protected
  int
  checkType  (String	strType	)
  {
  /* use Cmd to check validity of type and translate */
    return new Cmd( strType ).getEnum(  );
  }


  protected
  int
  checkType  (int	iType	)
  {
  /* use Cmd to check validity of type */
    return new Cmd( iType ).getEnum(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  int	m_iType		=  Cmd.NONE;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  /* building a GET-CAPABILITY reply */
  static public
  void  main  (String	argv[]	)
  {
    VReply	vreply		= new VReply( Cmd.GETCAPABILITY );
    CAPVersion	capversion	= new CAPVersion( "1.0" );
    CARLevel	carlevel	= new CARLevel( Names.strValue_CARNone );
    Components	components	= new Components(  );
    StoresExpanded	storesexpanded		=
				new StoresExpanded( Names.strValue_True );
    MaxDate	maxdate		= new MaxDate( "00010101T000000Z" );
    MinDate	mindate		= new MinDate( "00010101T000000Z" );
    ITIPVersion	itipversion	= new ITIPVersion( "2447" );
    MaxCompSize	maxcompsize	= new MaxCompSize( "1024" );
    MultiPart	multipart	= new MultiPart( "mixed" );
    QueryLevel	querylevel	= new QueryLevel( Names.strValue_CalQL1 );
    RecurAccepted	recuraccepted		=
				new RecurAccepted( Names.strValue_False );
    RecurExpand	recurexpand	= new RecurExpand( Names.strValue_False );
    RecurLimit	recurlimit	= new RecurLimit( "0" );
    XProp	xprop		= new XProp( "X-UW-PROP" , "test prop" );
    XParam	xparam		= new XParam( "X-UW-PARAM" );

    /*void*/System.out.println( "isComplete: " + vreply.isComplete(  ) );
    /*void*/System.out.println( vreply );

    try {
      /*void*/vreply.addProperty( capversion );
      /*void*/vreply.addProperty( carlevel );

      /*void*/components.addTexts( Names.strComp_VEvent );
      /*void*/vreply.addProperty( components );

      /*void*/vreply.addProperty( storesexpanded );
      /*void*/vreply.addProperty( maxdate );
      /*void*/vreply.addProperty( mindate );
      /*void*/vreply.addProperty( itipversion );
      /*void*/vreply.addProperty( maxcompsize );

      /*void*/multipart.addText( "related" );
      /*void*/vreply.addProperty( multipart );

      /*void*/vreply.addProperty( querylevel );
      /*void*/vreply.addProperty( recuraccepted );
      /*void*/vreply.addProperty( recurexpand );
      /*void*/vreply.addProperty( recurlimit );

      /*void*/xparam.set( "test param" );
      /*void*/xprop.addParameter( xparam );
      /*void*/vreply.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vreply.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vreply.isSupported(  ) );
    /*void*/System.out.println( vreply );
  }

}


/* Log:
 *  0.01  2003/01/13, 2003/02/10 ... 2003/02/26, 2003/04/23, 2003/04/28  slh
 *        (new year, new version...)
 *        MaxComponentSize -> MaxCompSize
 *        DateMax/Min -> Max/MinDate
 *        use .class to get class
 *        allow REQUEST-STATUS for IDENTIFY
 *        allow for any comp/prop for SEARCH
 *        getCalendarName()
 *        properly allow for any comp/prop for NONE: rm AddComponent/Property
 *        use Config.get*Class() to get class
 *        call setupComponent()
 *  0.00  2002/10/28 ... 2002/11/13, 2002/12/11, 2002/12/17 - 2002/12/18  slh
 *        create
 */
/*--VReply.java-------------------------------------------------------------*/
