/*++VQuery.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;


/**
 * CAP VQUERY component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.6 [CAP/09]
 *   comps:	none
 *   props:	QUERYID(0-1), TARGET(0-1)???, EXPAND(0-1)???,
 *		QUERY(1+),
 *		NAME(0+), iana-prop(0+), x-prop(0+)
 *   Note: if TARGET is present, then QUERYID must be present.
 * </PRE>
 *
 * @author  slh
 * @version  0.01 2003/04/22 slh
 */
public
class  VQuery
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VQUERY.
   */
  public
  VQuery  (		)
  {
    super( getCalendarName(  ) );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VQuery;
  }

/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    if (1 == m_properties.getCount( Target.class ) &&
	1 != m_properties.getCount( QueryId.class )) {
      return false;						/*RETURN*/
    }

    return super.isComplete(  );				/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding Component.configComponent()
    which is called in Component.Component(*).
  */
  protected
  void
  configComponent  (		)
  {
    m_vPropOnePlus = new Vector(  );
    /*void*/m_vPropOnePlus.add( Query.class );

    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( QueryId.class );
    /*void*/m_vPropZeroOne.add( Target.class );
    /*void*/m_vPropZeroOne.add( Expand.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Name.class );
    /*void*/m_vPropZeroPlus.add( IANAProp.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VQuery	vquery		= new VQuery(  );
    QueryId	queryid		= new QueryId( "an id" );
    Target	target		= new Target( "cap://slh.net/aloc" );
    Expand	expand		= new Expand( false );
    Query	query		= new Query( "SELECT something" );
    Name	name		= new Name( "a name" );
    IANAProp	ianaprop	= new IANAProp( "NEWPROP" , "a value" );
    XProp	xprop		= new XProp( "X-SLH-PROP" , "test prop" );

    /*void*/System.out.println( "isComplete: " + vquery.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vquery.isSupported(  ) );
    /*void*/System.out.println( vquery );

    try {
      /*void*/vquery.addProperty( query );
      /*void*/System.out.println( "isComplete: " + vquery.isComplete(  ) );
      /*void*/System.out.println( vquery );

      /*void*/vquery.addProperty( target );
      /*void*/System.out.println( "isComplete: " + vquery.isComplete(  ) );
      /*void*/System.out.println( vquery );

      /*void*/vquery.addProperty( queryid );
      /*void*/System.out.println( "isComplete: " + vquery.isComplete(  ) );
      /*void*/System.out.println( vquery );

      /*void*/vquery.addProperty( expand );
      /*void*/vquery.addProperty( name );
      /*void*/vquery.addProperty( ianaprop );
      /*void*/vquery.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vquery.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vquery.isSupported(  ) );
    /*void*/System.out.println( vquery );
  }

}


/* Log:
 *  0.01  2003/04/22  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        .getClass() -> .class
 *        getCount(String) -> getCount(Class)
 *  0.00  2002/11/12 - 2002/11/13, 2002/12/02 - 2002/12/03, 2002/12/11  slh
 *        create
 */
/*--VQuery.java-------------------------------------------------------------*/
