/*++VCalendar.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.ICalendar;
import  edu.washington.cac.calendar.icalendar.IANAProp;

import  edu.washington.cac.calendar.icalendar.ProdId;	/* for main */
import  edu.washington.cac.calendar.icalendar.Version;	/* for main */
import  edu.washington.cac.calendar.icalendar.XComp;	/* for main */
import  edu.washington.cac.calendar.icalendar.XProp;	/* for main */


/**
 * CAP VCALENDAR component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	1.3 [CAP/09]
???spec doesn't explicitly list comps and props
 *   comps:	*VEVENT(0+), VTODO(0+), VJOURNAL(0+), VFREEBUSY(0+),
 *		VTIMEZONE(0+),
 *		VAGENDA(0+), VQUERY(0+), VREPLY(0+),
 *		iana-comp(0+), x-comp(0+)*
 *   props:	PRODID(1), VERSION(1),
 *		CALSCALE(0-1), METHOD(0-1), CMD(0-1),
 *		TARGET(0+), iana-prop(0+), x-prop(0+)
 * *at least one must be present, except if a CMD is present*
 * </PRE>
 *
 * @author  slh
 * @version  0.01 2003/02/19 slh
 */
public
class  VCalendar
extends  ICalendar
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  VCalendar  (		)
  {
    super(  );		/* using same name */
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    /* if not a command and not at least one component present... */
    if (0 == m_properties.getCount( Names.strProp_Cmd ) &&
	m_components.size(  ) < 1) {
      return false;						/*RETURN*/
    }

    /* skip ICalendar.isComplete() */
    return super.isCompleteSuper(  );				/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    /*void*/super.configComponent(  );

   /* adding to iCalendar comps: */
    /*void*/m_vCompZeroPlus.add(
		Config.getCompClass( Names.strComp_VAgenda ) );
    /*void*/m_vCompZeroPlus.add(
		Config.getCompClass( Names.strComp_VQuery ) );
    /*void*/m_vCompZeroPlus.add(
		Config.getCompClass( Names.strComp_VReply ) );

   /* adding to iCalendar props: */
    /*void*/m_vPropZeroOne.add( Config.getPropClass( Names.strProp_Cmd ) );

    /*void*/m_vPropZeroPlus.add(
		Config.getPropClass( Names.strProp_Target ) );
    /*void*/m_vPropZeroPlus.add(
		Config.getPropClass( Names.strProp_IANA ) );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VCalendar	vcalendar	= new VCalendar(  );
    ProdId	prodid		= new ProdId(  );
    Version	version		= new Version( "2.0" );
    Cmd		cmd		= new Cmd( "ABORT" );
    XComp	xcomp		= new XComp( "X-UW-COMP" );
    XProp	xprop		= new XProp( "X-UW-PROP" , "test prop" );

    /*void*/System.out.println( "isComplete: " + vcalendar.isComplete(  ) );
    /*void*/System.out.println( vcalendar );

    try {
      /*void*/prodid.set( "slh/cap" );
      /*void*/vcalendar.addProperty( prodid );
      /*void*/vcalendar.addProperty( version );
      /*void*/vcalendar.addProperty( xprop );

      /*void*/System.out.println( "isComplete: " + vcalendar.isComplete(  ) );
      /*void*/System.out.println( vcalendar );

      /*void*/vcalendar.addProperty( cmd );

      /*void*/System.out.println( "isComplete: " + vcalendar.isComplete(  ) );
      /*void*/System.out.println( vcalendar );

      /*void*/xcomp.addProperty( xprop );
      /*void*/vcalendar.addComponent( xcomp );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vcalendar.isComplete(  ) );
    /*void*/System.out.println( vcalendar );
  }

}


/* Log:
 *  0.01  2003/01/28, 2003/02/10, 2003/02/19  slh
 *        (new year, new version...)
 *        isComplete(): effectively calls Component.isComplete()
 *        use Config.get*Class() to get class
 *  0.00  2002/10/30, 2002/11/05, 2002/12/18  slh
 *        create
 */
/*--VCalendar.java----------------------------------------------------------*/
