/*++VCalStore.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.VTimeZone;
import  edu.washington.cac.calendar.icalendar.CalScale;
import  edu.washington.cac.calendar.icalendar.Created;
import  edu.washington.cac.calendar.icalendar.LastModified;
import  edu.washington.cac.calendar.icalendar.RelatedTo;

import  edu.washington.cac.calendar.icalendar.XProp;		/* for main */
import  edu.washington.cac.calendar.icalendar.RelTypeParam;	/* for main */
import  edu.washington.cac.calendar.icalendar.RRule;		/* for main */
import  edu.washington.cac.calendar.icalendar.AltRepParam;	/* for main */


/**
 * CAP VCALSTORE component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.2, 3.2 [CAP/09]
 *   comps:	VCAR, VQUERY, VTIMEZONE, VAGENDA
 *   props:	ALLOW-CONFLICT(1), CALSCALE(1), CALMASTER(1), CREATED(1),
 *		CSID(1), DEFAULT-CHARSET(1), DEFAULT-LOCALE(1),
 *		DEFAULT-VCARS(1), DEFAULT-TZID(1), LAST-MODIFIED(1),
 *		CHILDREN(0+), NAME(0+), RELATED-TO(0+)
 * </PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/11 slh
 */
public
class  VCalStore
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VCALSTORE.
   */
  public
  VCalStore  (		)
  {
    super( Names.strComp_VCalStore );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding Component.configComponent()
    which is called in Component.Component(*).
  */
  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( new VCAR(  ).getClass(  ) );
    /*void*/m_vCompZeroPlus.add( new VQuery(  ).getClass(  ) );
    /*void*/m_vCompZeroPlus.add( new VTimeZone(  ).getClass(  ) );
    /*void*/m_vCompZeroPlus.add( new VAgenda(  ).getClass(  ) );

    m_vPropOne = new Vector(  );
    /*void*/m_vPropOne.add( new AllowConflict(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new CalScale(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new CalMaster(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new Created(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new CSID(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new DefaultCharSet(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new DefaultLocale(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new DefaultVCARs(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new DefaultTZID(  ).getClass(  ) );
    /*void*/m_vPropOne.add( new LastModified(  ).getClass(  ) );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( new Children(  ).getClass(  ) );
    /*void*/m_vPropZeroPlus.add( new Name(  ).getClass(   ));
    /*void*/m_vPropZeroPlus.add( new RelatedTo(  ).getClass(  ) );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VCalStore	vcalstore	= new VCalStore(  );
    AllowConflict	allowconflict	=
				new AllowConflict( AllowConflict.FALSE );
    CalScale	calscale	= new CalScale(  );
    CalMaster	calmaster	= new CalMaster( "mailto:slh@slh.net" );
    Created	created		= new Created(  );
    CSID	csid		= new CSID( "cap://slh.net/root" );
    DefaultCharSet	defaultcharset	= new DefaultCharSet(  );
    DefaultLocale	defaultlocale	= new DefaultLocale(  );
    DefaultVCARs	defaultvcars	= new DefaultVCARs(  );
    DefaultTZID		defaulttzid	= new DefaultTZID(  );
    LastModified	lastmodified	= new LastModified(  );
    Children	children	= new Children(  );
    Name	name		= new Name( "a description" );
    RelatedTo	relatedto	= new RelatedTo( "GUID666" );
    VCAR	vcar		= new VCAR(  );
    CARID	carid		= new CARID( "caridv" );
    VRight	vright		= new VRight(  );
    Permission	permission	= new Permission( Permission.ALL );
    Grant	grant		= new Grant( "slh@slh.net" );
    VQuery	vquery		= new VQuery(  );
    Query	query		= new Query( "select some junk" );
    VTimeZone	vtimezone	= new VTimeZone(  );
    RRule	rrule		= new RRule(  );
    AltRepParam	altrepparam	= new AltRepParam(  );
    VAgenda	vagenda		= new VAgenda(  );
    Owner	owner		= new Owner( "slh@slh.net" );
    XProp	xprop		= new XProp( "X-SLH-PROP" , "test" );

    /*void*/System.out.println( "isComplete: " + vcalstore.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcalstore.isSupported(  ) );
    /*void*/System.out.println( vcalstore );

    try {
      /*void*/created.set( "20021204T111111" );
      /*void*/lastmodified.set( "20021204T123456" );

      /*void*/vcalstore.addProperty( allowconflict );
      /*void*/vcalstore.addProperty( calscale );
      /*void*/vcalstore.addProperty( calmaster );
      /*void*/vcalstore.addProperty( created );
      /*void*/vcalstore.addProperty( csid );
      /*void*/vcalstore.addProperty( defaultcharset );
      /*void*/vcalstore.addProperty( defaultlocale );
      /*void*/vcalstore.addProperty( defaultvcars );
      /*void*/vcalstore.addProperty( defaulttzid );
      /*void*/vcalstore.addProperty( lastmodified );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vcalstore.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcalstore.isSupported(  ) );
    /*void*/System.out.println( vcalstore );

    try {
      /*void*/relatedto.addParameter(
		new RelTypeParam( RelTypeParam.CHILD ) );
      /*void*/vcalstore.addProperty( relatedto );

      /*void*/vcalstore.addProperty( children );
      /*void*/vcalstore.addProperty( name );
      /*void*/vcalstore.addProperty( relatedto );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vcalstore.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcalstore.isSupported(  ) );
    /*void*/System.out.println( vcalstore );

    try {
      /*void*/vright.addProperty( permission );
      /*void*/vright.addProperty( grant );
      /*void*/vcar.addComponent( vright );
      /*void*/vcar.addProperty( carid );
      /*void*/vcalstore.addComponent( vcar );

      /*void*/vquery.addProperty( query );
      /*void*/vcalstore.addComponent( vquery );

      /*void*/altrepparam.set( "altrepparam" );
      /*void*/rrule.addParameter( altrepparam );
      /*void*/rrule.set( "rrule" );
      /*void*/vtimezone.addProperty( rrule );
      /*void*/vcalstore.addComponent( vtimezone );

      /*void*/vagenda.addProperty( allowconflict );
      /*void*/vagenda.addProperty( calscale );
      /*void*/vagenda.addProperty( created );
      /*void*/vagenda.addProperty( lastmodified );
      /*void*/vagenda.addProperty( owner );
      /*void*/vcalstore.addComponent( vagenda );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vcalstore.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcalstore.isSupported(  ) );
    /*void*/System.out.println( vcalstore );

    /*void*/System.out.println(
		"NOTE: should throw InvalidPropertyException:" );
    try {
      /*void*/vcalstore.addProperty( allowconflict );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    /*void*/System.out.println(
		"NOTE: should throw InvalidPropertyException:" );
    try {
      /*void*/vcalstore.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    /*void*/System.out.println( "isComplete: " + vcalstore.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcalstore.isSupported(  ) );
    /*void*/System.out.println( vcalstore );
  }

}


/* Log:
 *  0.00  2002/11/12 - 2002/11/13, 2002/12/03, 2002/12/04, 2002/12/11  slh
 *        create
 */
/*--VCalStore.java----------------------------------------------------------*/
