/*++VCAR.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;


/**
 * CAP VCAR component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.3 [CAP/09]
 *   comps:	VRIGHT (1+)
 *   props:	CARID(1),
 *		DECREED(0-1),
 *		NAME(0+), iana-prop(0+), x-prop(0+)
 * </PRE>
 *
 * @author slh
 * @version 0.01 2003/01/28 slh
 */
public
class  VCAR
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a VCAR component.
   */
  public
  VCAR  (		)
  {
    super( Names.strComp_VCAR );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding Component.configComponent()
    which is called in Component.Component(*).
  */
  protected
  void
  configComponent  (		)
  {
    m_vCompOnePlus = new Vector(  );
    /*void*/m_vCompOnePlus.add( VRight.class );

    m_vPropOne = new Vector(  );
    /*void*/m_vPropOne.add( CARID.class );

    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Decreed.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Name.class );
    /*void*/m_vPropZeroPlus.add( IANAProp.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VCAR	vcar		= new VCAR(  );
    Decreed	decreed		= new Decreed( "TRUE" );
    Name	name		= new Name( "a name" );
    IANAProp	ianaprop	= new IANAProp( "NEWPROP" , "content" );
    XProp	xprop		= new XProp( "X-SLH-PROP" , "test prop" );
    VRight	vright		= new VRight(  );
    Permission	permission	= new Permission( Permission.ALL );
    Grant	grant		= new Grant( "slh@slh.net" );
    CARID	carid		= new CARID( "an id" );

    /*void*/System.out.println( "isComplete: " + vcar.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcar.isSupported(  ) );
    /*void*/System.out.println( vcar );

    try {
      /*void*/vright.addProperty( permission );
      /*void*/vright.addProperty( grant );
      /*void*/vcar.addComponent( vright );

      /*void*/vcar.addProperty( carid );
      /*void*/vcar.addProperty( decreed );
      /*void*/vcar.addProperty( name );
      /*void*/vcar.addProperty( ianaprop );
      /*void*/vcar.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vcar.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vcar.isSupported(  ) );
    /*void*/System.out.println( vcar );
  }

}


/* Log:
 *  0.01  2003/01/28  slh
 *        (new year, new version...)
 *        use .class to get class
 *  0.00  2002/11/12 - 2002/11/13, 2002/12/02 - 2002/12/03, 2002/12/11  slh
 *        create
 */
/*--VCAR.java---------------------------------------------------------------*/
