/*++VAgenda.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.VEvent;
import  edu.washington.cac.calendar.icalendar.VTodo;
import  edu.washington.cac.calendar.icalendar.VJournal;
import  edu.washington.cac.calendar.icalendar.VTimeZone;
import  edu.washington.cac.calendar.icalendar.VFreeBusy;
import  edu.washington.cac.calendar.icalendar.XComp;
import  edu.washington.cac.calendar.icalendar.CalScale;
import  edu.washington.cac.calendar.icalendar.Created;
import  edu.washington.cac.calendar.icalendar.LastModified;
import  edu.washington.cac.calendar.icalendar.RelatedTo;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;

import  edu.washington.cac.calendar.icalendar.RelTypeParam;	/* for main */


/**
 * CAP VAGENDA component.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 *
 * Spec:
 *   section:	9.1, 3.2 [CAP/09]
 *   comps:	VEVENT, VTODO, VJOURNAL, VCAR, VTIMEZONE, VQUERY, VFREEBUSY,
 *		x-comp
 *   (stored:)
 *   props:	ALLOW-CONFLICT(1), CALID(1), CALSCALE(1), CREATED(1),
 *		DEFAULT-CHARSET(1), DEFAULT-LOCALE(1), DEFAULT-TZID(1),
 *		LAST-MODIFIED(1),
 *		OWNER(1+),
 *		NAME(0+), RELATED-TO(0+), iana-prop(0+)???, x-prop(0+) 
 *   (create:)
 *   props:	ALLOW-CONFLICT(1), CALID(1), CALSCALE(1),
 *		DEFAULT-CHARSET(1), DEFAULT-LOCALE(1), DEFAULT-TZID(1),
 *		OWNER(1+),
 *		NAME(0+), RELATED-TO(0+), iana-prop(0+)???, x-prop(0+)
 *		(examples also show: CALMASTER, TZID)???
 *
 * ``; The following MUST occur at least once.
 *   ; and the value MUST NOT be empty.
 *   / owner''
 * </PRE>
 *
 * @author  slh
 * @version  0.01 2003/04/22 slh
 */
public
class  VAgenda
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a stored VAGENDA.
   *
   * This is equivalent to VAgenda( false ).
   */
  public
  VAgenda  (		)
  {
    this( false );
  }


  /**
   * Create a VAGENDA in the mode indicated.
   *
   * @param
   * bCreate	if true then this is a create VAGENDA,
   *		otherwise it is a stored VAGENDA.
   */
  public
  VAgenda  (boolean	bCreate	)
  {
    super( getCalendarName(  ) );

    /*Note: need to call explicitly since different sig*/
    /*void*/configComponent( bCreate );
    try {
      /*void*/setupComponent(  );
    } catch (Exception	e	) {
      throw new InternalError( getName(  ) + ": " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_VAgenda;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    /* do nothing - results of explicitely called other one is what is used */
  }


  /*Note: not overriding Component.configComponent()*/
  protected
  void
  configComponent  (boolean	bCreate	)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( VEvent.class );
    /*void*/m_vCompZeroPlus.add( VTodo.class );
    /*void*/m_vCompZeroPlus.add( VJournal.class );
    /*void*/m_vCompZeroPlus.add( VCAR.class );
    /*void*/m_vCompZeroPlus.add( VTimeZone.class );
    /*void*/m_vCompZeroPlus.add( VQuery.class );
    /*void*/m_vCompZeroPlus.add( VFreeBusy.class );
    /*void*/m_vCompZeroPlus.add( XComp.class );

    m_vPropOne = new Vector(  );
    /*void*/m_vPropOne.add( AllowConflict.class );
    /*void*/m_vPropOne.add( CalId.class );
    /*void*/m_vPropOne.add( CalScale.class );
    /*void*/m_vPropOne.add( DefaultCharSet.class );
    /*void*/m_vPropOne.add( DefaultLocale.class );
    /*void*/m_vPropOne.add( DefaultTZID.class );
    if (!bCreate) {
      /*void*/m_vPropOne.add( Created.class );
      /*void*/m_vPropOne.add( LastModified.class );
    }

    m_vPropOnePlus = new Vector(  );
    /*void*/m_vPropOnePlus.add( Owner.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( Name.class );
    /*void*/m_vPropZeroPlus.add( RelatedTo.class );
    /*void*/m_vPropZeroPlus.add( IANAProp.class );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    VAgenda	vagenda		= new VAgenda(  );
    AllowConflict	allowconflict	=
				new AllowConflict( AllowConflict.FALSE );
    CalId	calid		= new CalId( "cap://slh.net" );
    CalScale	calscale	= new CalScale(  );
    Created	created		= new Created(  );
    DefaultCharSet	defaultcharset	= new DefaultCharSet(  );
    DefaultLocale	defaultlocale	= new DefaultLocale(  );
    DefaultTZID		defaulttzid	= new DefaultTZID(  );
    LastModified	lastmodified	= new LastModified(  );
    Owner	owner		= new Owner( "slh@slh.net" );
    Name	name		= new Name( "a description" );
    RelatedTo	relatedto	= new RelatedTo( "GUID666" );
    IANAProp	ianaprop	= new IANAProp( "IANAPROP" , "ianavalue" );
    XProp	xprop		= new XProp( "X-SLH-PROP" , "test prop" );
    VEvent	vevent		= new VEvent(  );
    VTodo	vtodo		= new VTodo(  );
    VJournal	vjournal	= new VJournal(  );
    VCAR	vcar		= new VCAR(  );
    CARID	carid		= new CARID( "caridv" );
    VRight	vright		= new VRight(  );
    Permission	permission	= new Permission( Permission.ALL );
    Grant	grant		= new Grant( "slh@slh.net" );
    VTimeZone	vtimezone	= new VTimeZone(  );
    VQuery	vquery		= new VQuery(  );
    Query	query		= new Query( "select some junk" );
    VFreeBusy	vfreebusy	= new VFreeBusy(  );
    XComp	xcomp		= new XComp( "X-SLH-COMP" );

    /*void*/System.out.println( "isComplete: " + vagenda.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vagenda.isSupported(  ) );
    /*void*/System.out.println( vagenda );

    try {
      /*void*/created.set( "20021204T111111" );
      /*void*/lastmodified.set( "20021204T123456" );

      /*void*/vagenda.addProperty( allowconflict );
      /*void*/vagenda.addProperty( calid );
      /*void*/vagenda.addProperty( calscale );
      /*void*/vagenda.addProperty( created );
      /*void*/vagenda.addProperty( defaultcharset );
      /*void*/vagenda.addProperty( defaultlocale );
      /*void*/vagenda.addProperty( defaulttzid );
      /*void*/vagenda.addProperty( lastmodified );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vagenda.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vagenda.isSupported(  ) );
    /*void*/System.out.println( vagenda );

    try {
      /*void*/vagenda.addProperty( owner );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vagenda.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vagenda.isSupported(  ) );
    /*void*/System.out.println( vagenda );

    try {
      /*void*/vagenda.addProperty( name );
      /*void*/relatedto.addParameter(
		new RelTypeParam( RelTypeParam.CHILD ) );
      /*void*/vagenda.addProperty( relatedto );
      /*void*/vagenda.addProperty( ianaprop );
      /*void*/vagenda.addProperty( xprop );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "isComplete: " + vagenda.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vagenda.isSupported(  ) );
    /*void*/System.out.println( vagenda );

    try {
      /*void*/vevent.addProperty( xprop );
      /*void*/vagenda.addComponent( vevent );

      /*void*/vtodo.addProperty( xprop );
      /*void*/vagenda.addComponent( vtodo );

      /*void*/vjournal.addProperty( xprop );
      /*void*/vagenda.addComponent( vjournal );

      /*void*/vright.addProperty( permission );
      /*void*/vright.addProperty( grant );
      /*void*/vcar.addComponent( vright );
      /*void*/vcar.addProperty( carid );
      /*void*/vagenda.addComponent( vcar );

      /*void*/vtimezone.addProperty( xprop );
      /*void*/vagenda.addComponent( vtimezone );

      /*void*/vquery.addProperty( query );
      /*void*/vagenda.addComponent( vquery );

      /*void*/vfreebusy.addProperty( xprop );
      /*void*/vagenda.addComponent( vfreebusy );

      /*void*/xcomp.addProperty( xprop );
      /*void*/vagenda.addComponent( xcomp );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw InvalidPropertyException:" );
    try {
      /*void*/vagenda.addProperty( allowconflict );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }

    /*void*/System.out.println( "isComplete: " + vagenda.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + vagenda.isSupported(  ) );
    /*void*/System.out.println( vagenda );
  }

}


/* Log:
 *  0.01  2003/01/13, 2003/04/22  slh
 *        (new year, new version...)
 *        call setupComponent()
 *  0.00  2002/10/30 ... 2002/11/13, 2002/12/04, 2002/12/11  slh
 *        create
 */
/*--VAgenda.java------------------------------------------------------------*/
