/*++UPNParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.net.URL;
import  java.net.MalformedURLException;

import  edu.washington.cac.calendar.icalendar.TextParam;


/**
 * Base for CAP UPN-valued parameters.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	6.1.2 [CAP/09]
 * </PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
abstract public
class  UPNParam
extends  TextParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a UPN parameter, unset.
   */
  protected
  UPNParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a UPN parameter set to supplied value.
   */
  protected
  UPNParam  (String	strName		,
	     String	strValue	)
  {
    super( strName );

    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (String	strValue	)
  throws Exception
  {
    try {
      /* check format */
//???might not be quite right
//???actually, seems to accept anything as long as there is a "mailto:"
      new URL( "mailto:" + strValue );
    } catch (MalformedURLException	e	) {
      throw new MalformedUPNException( getName(  ) +
		": malformed UPN: " + strValue );
    }

    /* if no @ or not just @ but ends in @ or more than one @ then... */
    if (-1 == strValue.indexOf( "@" ) ||
	(!strValue.equals( "@" ) &&
	 strValue.indexOf( "@" ) == strValue.length(  ) - 1) ||
	strValue.indexOf( "@" ) != strValue.lastIndexOf( "@" )) {
      throw new MalformedUPNException( getName(  ) +
		": malformed UPN: " + strValue );
    }

    /*void*/super.set( strValue );
  }

}


/* Log:
 *  0.00  2002/12/10  slh
 *        create from UPNProp.java
 */
/*--UPNParam.java-----------------------------------------------------------*/
