/*++UPNFilterProp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.UnsupProp;


/**
 * Base class for CAP UPN-FILTER-valued properties.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	6.1.3 [CAP/09]
 *</PRE>
 *
 * Currently just a wrapper for UnsupProp.
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
abstract public
class  UPNFilterProp
extends  UnsupProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a UPN-FILTER property unset.
   */
  protected
  UPNFilterProp  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a UPN-FILTER property set to supplied value.
   */
  protected
  UPNFilterProp  (String	strName		,
		  String	strValue	)
  {
    super( strName , strValue );
  }

}


/* Log:
 *  0.00  2002/12/02, 2002/12/10  slh
 *        create
 */
/*--UPNFilterProp.java------------------------------------------------------*/
