/*++Transp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;
import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.IANAParam;
import  edu.washington.cac.calendar.icalendar.XParam;


/**
 * CAP TRANSP property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.37 [CAP-10]
 *   occurs:	VEVENT (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	"OPAQUE"
 *   allowed:	"OPAQUE" / "TRANSPARENT" /
 *		"TRANSPARENT-NOCONFLICT" / "OPAQUE-NOCONFLICT"
 *   params:	ianaparam(0+), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10  2003/04/30 slh
 */
public
class  Transp
extends  edu.washington.cac.calendar.icalendar.Transp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a TRANSP property, set to default.
   */
  public
  Transp  (		)
  {
    super(  );
  }


  /**
   * Create a TRANSP property set to supplied value.
   */
  public
  Transp  (String	strValue	)
  {
    super( strValue );
  }


  /**
   * Create a TRANSP property set to supplied value.
   */
  public
  Transp  (int	iValue	)
  {
    super( iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( IANAParam.class );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }


  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( OPAQUE ) , Names.strValue_Opaque );
    m_hmValue.put( new Integer( TRANSPARENT ) , Names.strValue_Transparent );
    m_hmValue.put( new Integer( TRANSPARENTNOCONFLICT ) ,
		   Names.strValue_TransparentNoConflict );
    m_hmValue.put( new Integer( OPAQUENOCONFLICT ) ,
		   Names.strValue_OpaqueNoConflict );

    m_strDefault = Names.strValue_Opaque;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	OPAQUE			=  1;
  final static public  int	TRANSPARENT		=  2;
  final static public  int	TRANSPARENTNOCONFLICT	=  3;
  final static public  int	OPAQUENOCONFLICT	=  4;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Transp	Transp		= new Transp(  );

    /*void*/edu.washington.cac.calendar.icalendar.Config.init(  );
    /*void*/Config.init(  );

    /*void*/System.out.println( Transp.getCalendarName(  ) );

    try {
      /*void*/Transp.set( OPAQUE );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( TRANSPARENT );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( TRANSPARENTNOCONFLICT );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( OPAQUENOCONFLICT );
      /*void*/System.out.println( Transp );

      /*void*/Transp.set( "OPAQUE" );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( "TRANSPARENT" );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( "TRANSPARENT-NOCONFLICT" );
      /*void*/System.out.println( Transp );
      /*void*/Transp.set( "OPAQUE-NOCONFLICT" );
      /*void*/System.out.println( Transp );

      /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
      /*void*/Transp.set( "foo" );
      /*void*/System.out.println( Transp );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.10  2003/04/21, 2003/04/30  slh
 *        (new year, new version...)
 *        allow ianaprops
 *        derive from icalendar.Transp (instead of icalendar.EnumProp)
 *  0.00  2002/11/13, 2002/12/02  slh
 *        create from Permission.java
 */
/*--Transp.java-------------------------------------------------------------*/
