/*++RecurLimit.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.NonnegativeIntegerProp;


/**
 * CAP RECUR-LIMIT property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.3 [CAP/09]
 *   occurs:	0-1 (CMD)
 *   datatypes:	INTEGER/nonnegative (1)
 *   default:	---
 *   allowed:	>= 0
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/02/05 slh
 */
public
class  RecurLimit
extends  NonnegativeIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RECUR-LIMIT property, unset.
   */
  public
  RecurLimit  (		)
  {
    super( Names.strProp_RecurLimit );
  }


  /**
   * Create a RECUR-LIMIT property set to indicated value.
   */
  public
  RecurLimit  (String	strValue	)
  {
    super( Names.strProp_RecurLimit , strValue );
  }


  /**
   * Create a RECUR-LIMIT property set to indicated value.
   */
  public
  RecurLimit  (Integer	IValue	)
  {
    super( Names.strProp_RecurLimit , IValue );
  }


  /**
   * Create a RECUR-LIMIT property set to indicated value.
   */
  public
  RecurLimit  (int	iValue	)
  {
    super( Names.strProp_RecurLimit , iValue );
  }

}


/* Log:
 *  0.01  2003/02/05  slh
 *        (new year, new version...)
 *        RecurLimit(Integer), RecurLimit(int)
 *  0.00  2002/10/30  slh
 *        create from MaxComponentSize.java
 */
/*--RecurLimit.java---------------------------------------------------------*/
