/*++QueryLevel.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.EnumProp;


/**
 * CAP QUERY-LEVEL property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.3 [CAP/09]
 *   occurs:	1 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (1)
 *   default:	"CAL-QL-1"
 *   allowed:	"CAL-QL-NONE", "CAL-QL-1"
 *   params:	xparam (0+)???
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  QueryLevel
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a QUERY-LEVEL property set to default value.
   */
  public
  QueryLevel  (		)
  {
    super( Names.strProp_QueryLevel );
  }


  /**
   * Create a QUERY-LEVEL property set to supplied value.
   */
  public
  QueryLevel  (String	strValue	)
  {
    super( Names.strProp_QueryLevel , strValue );
  }


  /**
   * Create a QUERY-LEVEL property set to supplied value.
   */
  public
  QueryLevel  (int	iValue	)
  {
    super( Names.strProp_QueryLevel , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( CALQLNONE ) , Names.strValue_CalQLNone );
    m_hmValue.put( new Integer( CALQL1 ) , Names.strValue_CalQL1 );

    m_strDefault = Names.strValue_CalQL1;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	CALQLNONE	=  1;
  final static public  int	CALQL1		=  2;

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        redo constructors
 *        NONE -> CAL-QL-NONE
 *  0.00  2002/10/28, 2002/10/29  slh
 *        create
 */
/*--QueryLevel.java---------------------------------------------------------*/
