/*++Permission.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.EnumProp;


/**
 * CAP PERMISSION property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.20 [CAP/09]
 *   occurs:	1+ (VRIGHT)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"SEARCH" / "CREATE" / "DELETE" / "MODIFY" / "*"
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/02 slh
 */
public
class  Permission
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a PERMISSION property, unset.
   */
  public
  Permission  (		)
  {
    super( Names.strProp_Permission );
  }


  /**
   * Create a PERMISSION property set to supplied value.
   */
  public
  Permission  (String	strValue	)
  {
    super( Names.strProp_Permission , strValue );
  }


  /**
   * Create a PERMISSION property set to supplied value.
   */
  public
  Permission  (int	iValue	)
  {
    super( Names.strProp_Permission , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( SEARCH ) , Names.strValue_Search );
    m_hmValue.put( new Integer( CREATE ) , Names.strValue_Create );
    m_hmValue.put( new Integer( DELETE ) , Names.strValue_Delete );
    m_hmValue.put( new Integer( MODIFY ) , Names.strValue_Modify );
    m_hmValue.put( new Integer( ALL ) , Names.strValue_All );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	SEARCH		=  1;
  final static public  int	CREATE		=  2;
  final static public  int	DELETE		=  3;
  final static public  int	MODIFY		=  4;
  final static public  int	ALL		=  5;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Permission	permission	= new Permission(  );

    try {
      /*void*/permission.set( SEARCH );
      /*void*/System.out.println( permission );
      /*void*/permission.set( CREATE );
      /*void*/System.out.println( permission );
      /*void*/permission.set( DELETE );
      /*void*/System.out.println( permission );
      /*void*/permission.set( MODIFY );
      /*void*/System.out.println( permission );
      /*void*/permission.set( ALL );
      /*void*/System.out.println( permission );

      /*void*/permission.set( "SEARCH" );
      /*void*/System.out.println( permission );
      /*void*/permission.set( "CREATE" );
      /*void*/System.out.println( permission );
      /*void*/permission.set( "delete" );
      /*void*/System.out.println( permission );
      /*void*/permission.set( "modify" );
      /*void*/System.out.println( permission );
      /*void*/permission.set( "*" );
      /*void*/System.out.println( permission );

      /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
      /*void*/permission.set( "foo" );
      /*void*/System.out.println( permission );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.00  2002/11/13, 2002/12/02  slh
 *        create
 */
/*--Permission.java---------------------------------------------------------*/
