/*++Parser.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.io.BufferedReader;
import  java.io.InputStreamReader;				/* for main */
import  java.io.Reader;
import  java.io.StreamTokenizer;
import  java.io.IOException;

import  edu.washington.cac.calendar.icalendar.Collectible;
import  edu.washington.cac.calendar.icalendar.Component;
import  edu.washington.cac.calendar.icalendar.Property;
import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.IANAComp;
import  edu.washington.cac.calendar.icalendar.XComp;
import  edu.washington.cac.calendar.icalendar.IANAProp;
import  edu.washington.cac.calendar.icalendar.XProp;
import  edu.washington.cac.calendar.icalendar.IANAParam;
import  edu.washington.cac.calendar.icalendar.XParam;
import  edu.washington.cac.calendar.uwical.text.RootFormatter;
import  edu.washington.cac.calendar.icalendar.instrumentation.ComponentDumper;
import  edu.washington.cac.calendar.icalendar.xml.RootXMLer;
								/* for main */


/**
 * Parse CAP stream.
 *
 * @author  slh
 * @version  0.10 2003/06/18 slh
 */
public
class  Parser
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a parser that parses the supplied stream.
   */
  public
  Parser  (Reader	reader	)
  {
    m_st = new StreamTokenizer( new BufferedReader( reader ) );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  Collectible
  parse  (boolean	bPositioned	)
  throws Exception	/*, InvalidCAPStreamException, IOException*/
  {
    m_bPositioned = bPositioned;
    return parse(  );
  }


  /**
   * Parse CAP stream.
   *
   * Parses one top-level component.
   *
   * Note: assumes top-level objects is a component.
//???eventually component or property?
//???can selected based on if BEGIN found
//???redistrib w/addComponent()
   */
  public
  Collectible
  parse  (		)
  throws Exception	/*, InvalidCAPStreamException, IOException*/
  {
//???only needed for check below
    Collectible	collectible	= null;

    /*void*/setupNameChars( m_st );

    if (!m_bPositioned) {
     /* do initial positioning to beginning of first object */
      /*(void)*/m_st.nextToken(  );
      m_bPositioned = true;
    }

    if (m_st.ttype != m_st.TT_EOF) {
      collectible = addComponent( null , m_st );
    }

//???
    if (m_st.ttype != m_st.TT_EOF) {
      /*void*/System.err.println( "WARNING: extraneous text" );
    }

    return collectible;
  }


/*----------------------------------------------------------------------------
 *						Class Protected Methods
 *--------------------------------------------------------------------------*/
//???make a lot/all of these object methods
/*-------------------------------------- add* Methods			*/
					
  /**
   * Add component created from a stream.
   *
   * compParent may be null, in which case creating a top-level component.
   *
   * Note: assumes tokenizer has been positioned at beginning of component.
   */
  static protected
  Component
  addComponent  (Component		compParent	,
		 StreamTokenizer	st		)
  throws Exception	/*, InvalidCAPStreamException, IOException*/
  {
    String	strName;
    Component	compChild;

    /*void*/eatWord( st , Strings.strBegin );
    /*void*/eatChar( st , Strings.chCompValueInducer );
    /*void*/checkForWord( st , "component name" );
    strName = st.sval;
    compChild = newComponent( strName );
    if (compParent != null) {
      /*void*/compParent.addComponent( compChild );
    }
    /*(void)*/st.nextToken(  );
    /*void*/eatEOL( st );

    for ( ; st.ttype == st.TT_WORD &&
	    !st.sval.equalsIgnoreCase( Strings.strEnd ) ; ) {
      if (st.sval.equalsIgnoreCase( Strings.strBegin )) {
	/*(void)*/addComponent( compChild , st );
      } else {
	/*(void)*/addProperty( compChild , st );
      }
    }

    /*void*/eatWord( st , Strings.strEnd );
    /*void*/eatChar( st , Strings.chCompValueInducer );
    /*void*/eatWord( st , strName );
    /*void*/eatEOL( st );

    return compChild;
  }


  /**
   * Add property created from a stream.
   *
   * compParent must not be null.
   *
   * Note: assumes tokenizer has been positioned at name of property.
   */
  static protected
  Property
  addProperty  (Component	compParent	,
		StreamTokenizer	st		)
  throws Exception	/*, InvalidCAPStreamException, IOException*/
  {
    Property	propChild;

    /*void*/checkForWord( st , "property name" );
    propChild = newProperty( st.sval );
    /*void*/compParent.addProperty( propChild );
    /*(void)*/st.nextToken(  );

    for ( ; st.ttype == Strings.chParamInducer ; ) {
      /*(void)*/st.nextToken(  );
      /*(void)*/addParameter( propChild , st );
    }

    /*void*/setupValueChars( st );
    /*void*/eatChar( st , Strings.chPropValueInducer );
    /*void*/propChild.set( st.sval );
    /*(void)*/st.nextToken(  );
    /*void*/setupNameChars( st );
    /*void*/eatEOL( st );

    return propChild;
  }


  /**
   * Add parameter created from a stream.
   *
   * propParent must not be null.
   *
   * Note: assumes tokenizer has been positioned at name of parameter.
   */
  static protected
  Parameter
  addParameter  (Property		propParent	,
		 StreamTokenizer	st		)
  throws Exception	/*, InvalidCAPStreamException, IOException*/
  {
    Parameter	paramChild;

    /*void*/checkForWord( st , "parameter name" );
    paramChild = newParameter( st.sval );
    /*void*/propParent.addParameter( paramChild );
    /*(void)*/st.nextToken(  );

    /*void*/eatChar( st , Strings.chParamValueInducer , false );
    /*void*/paramChild.set( collectParamValues( st ) );

    return paramChild;
  }


  /**
   *
   * st should be positioned just before param value(s).
   */
  static protected
  String
  collectParamValues  (StreamTokenizer	st	)
  throws InvalidCAPStreamException, IOException
  {
    String	strValue	= "";

    do {
      /*Note: either safe chars will exclude quote,
	but this one will do the right thing when not quoted*/
      /*void*/setupSafeChars( st );
      /*(void)*/st.nextToken(  );
      if        (st.ttype != Strings.chParamValueQuote) {
	strValue += st.sval;
      } else {
	strValue += Strings.chParamValueQuote;
	/*void*/setupQSafeChars( st );
	/*(void)*/st.nextToken(  );
	strValue += st.sval;
	/*(void)*/st.nextToken(  );
	/*void*/eatChar( st , Strings.chParamValueQuote , false );
	strValue += Strings.chParamValueQuote;
      }
      /*Note: name excludes value separator and
	param and prop value inducers and
	setups for return if this is the end of param values*/
      /*void*/setupNameChars( st );
      /*(void)*/st.nextToken(  );
      if (st.ttype == Strings.chParamValueSeparator) {
	strValue += Strings.chParamValueSeparator;
      }
    } while (st.ttype == Strings.chParamValueSeparator);

    return strValue;
  }


/*-------------------------------------- Checking Methods		*/

  static protected
  void
  checkForWord  (StreamTokenizer	st		,
		 String			strExpected	)
  throws InvalidCAPStreamException
  {
    if (st.ttype != st.TT_WORD) {
      throw new InvalidCAPStreamException( "expected: " + strExpected );
    }
  }


  static protected
  void
  eatWord  (StreamTokenizer	st	,
	    String		str	)
  throws InvalidCAPStreamException, IOException
  {
    if (st.ttype != st.TT_WORD || !st.sval.equalsIgnoreCase( str )) {
      throw new InvalidCAPStreamException( "expected: \"" + str + "\"" );
    }
    /*(void)*/st.nextToken(  );
  }


  static protected
  void
  eatChar  (StreamTokenizer	st	,
	    char		ch	)
  throws InvalidCAPStreamException, IOException
  {
    /*void*/eatChar( st , ch , true );
  }


  static protected
  void
  eatChar  (StreamTokenizer	st	,
	    char		ch	,
	    boolean		bEat	)
  throws InvalidCAPStreamException, IOException
  {
    if (st.ttype != ch) {
      throw new InvalidCAPStreamException( "expected: '" + ch + "'" );
    }
    if (bEat) {
      /*(void)*/st.nextToken(  );
    }
  }


  /**
   * Note: assumes tokenizer has been position at CR.
   */
  static protected
  void
  eatEOL  (StreamTokenizer	st	)
  throws InvalidCAPStreamException, IOException
  {
    if (st.ttype != st.TT_EOL) {
      throw new InvalidCAPStreamException( "expected: line-terminator" );
    }
    /*(void)*/st.nextToken(  );
  }


/*-------------------------------------- new* Methods			*/

  static protected
  Component
  newComponent  (String		strName	)
  throws Exception	/* InvalidCAPStreamException, ... */
  {
    java.lang.Class	jlclass;
    Object		objComp;
    java.lang.Class	ajlclass[]	= {strName.getClass(  )};
    Object		aobject[]	= {strName};

    if (null == (jlclass = Config.getCompClass( strName ))) {
      throw new InvalidCAPStreamException(
		"invalid component name: " + strName );
    }

    if (!IANAComp.class.isAssignableFrom( jlclass ) &&
	!XComp.class.isAssignableFrom( jlclass )) {
      objComp = jlclass.newInstance(  );
    } else {
      objComp = jlclass.getConstructor( ajlclass ).newInstance( aobject );
    }

    return (Component)objComp;
  }


  static protected
  Property
  newProperty  (String	strName	)
  throws Exception	/* InvalidCAPStreamException, ... */
  {
    java.lang.Class	jlclass;
    Object		objProp;
    java.lang.Class	ajlclass[]	= {strName.getClass(  )};
    Object		aobject[]	= {strName};

    if (null == (jlclass = Config.getPropClass( strName ))) {
      throw new InvalidCAPStreamException(
		"invalid property name: " + strName );
    }

    if (!IANAProp.class.isAssignableFrom( jlclass ) &&
	!XProp.class.isAssignableFrom( jlclass )) {
      objProp = jlclass.newInstance(  );
    } else {
      objProp = jlclass.getConstructor( ajlclass ).newInstance( aobject );
    }

    return (Property)objProp;
  }


  static protected
  Parameter
  newParameter  (String		strName	)
  throws Exception	/* InvalidCAPStreamException, ... */
  {
    java.lang.Class	jlclass;
    Object		objParam;
    java.lang.Class	ajlclass[]	= {strName.getClass(  )};
    Object		aobject[]	= {strName};

    if (null == (jlclass = Config.getParamClass( strName ))) {
      throw new InvalidCAPStreamException(
		"invalid parameter name: " + strName );
    }

    if (!IANAParam.class.isAssignableFrom( jlclass ) &&
	!XParam.class.isAssignableFrom( jlclass )) {
      objParam = jlclass.newInstance(  );
    } else {
      objParam = jlclass.getConstructor( ajlclass ).newInstance( aobject );
    }

    return (Parameter)objParam;
  }


/*-------------------------------------- Tokenizer Table Setup Methods	*/

  static protected
  void
  setupBase  (StreamTokenizer	st	)
  {
    /*void*/st.resetSyntax(  );

    /* this setup will allow either CRLF or CR or LF for line-terminators */
    /*void*/st.eolIsSignificant( true );
    /*void*/st.whitespaceChars( '\r' , '\r' );
    /*void*/st.whitespaceChars( '\n' , '\n' );

    /*void*/st.slashSlashComments( false );
    /*void*/st.slashStarComments( false );
  }


  static protected
  void
  setupNameChars  (StreamTokenizer	st	)
  {
    /*void*/setupBase( st );
    /*
     name               = x-name / iana-token

     iana-token = 1*(ALPHA / DIGIT / "-")
     ; iCalendar identifier registered with IANA

     x-name             = "X-" [vendorid "-"] 1*(ALPHA / DIGIT / "-")
     ; Reservered for experimental use. Not intended for use in
     ; released products.

     vendorid   = 3*(ALPHA / DIGIT)     ;Vendor identification
    */
    /*void*/st.wordChars( 0x41 , 0x5A );	/* A-Z */
    /*void*/st.wordChars( 0x61 , 0x7A );	/* a-z */
    /*void*/st.wordChars( 0x30 , 0x39 );	/* 0-9 */
    /*void*/st.wordChars( '-' , '-' );
  }


  static protected
  void
  setupValueChars  (StreamTokenizer	st	)
  {
    /*void*/setupBase( st );
    /*
      value      = *VALUE-CHAR

      VALUE-CHAR = WSP / %x21-7E / NON-US-ASCII
      ; Any textual character
    */
    /*void*/st.wordChars( ' ' , ' ' );
    /*void*/st.wordChars( '\t' , '\t' );
    /*void*/st.wordChars( 0x21 , 0x7E );
    /*void*/st.wordChars( 0x80 , 0xF8 );
  }


  static protected
  void
  setupSafeChars  (StreamTokenizer	st	)
  {
    /*void*/setupBase( st );
    /*
      param-value        = paramtext / quoted-string

      paramtext  = *SAFE-CHAR

      SAFE-CHAR  = WSP / %x21 / %x23-2B / %x2D-39 / %x3C-7E
                 / NON-US-ASCII
      ; Any character except CTLs, DQUOTE, ";", ":", ","
    */
    /*void*/st.wordChars( ' ' , ' ' );
    /*void*/st.wordChars( '\t' , '\t' );
    /*void*/st.wordChars( 0x21 , 0x21 );
    /*void*/st.wordChars( 0x23 , 0x2B );
    /*void*/st.wordChars( 0x2D , 0x39 );
    /*void*/st.wordChars( 0x3C , 0x7E );
    /*void*/st.wordChars( 0x80 , 0xF8 );
  }


  static protected
  void
  setupQSafeChars  (StreamTokenizer	st	)
  {
    /*void*/setupBase( st );
    /*
      param-value        = paramtext / quoted-string

      quoted-string      = DQUOTE *QSAFE-CHAR DQUOTE

      QSAFE-CHAR = WSP / %x21 / %x23-7E / NON-US-ASCII
      ; Any character except CTLs and DQUOTE
    */
    /*void*/st.wordChars( ' ' , ' ' );
    /*void*/st.wordChars( '\t' , '\t' );
    /*void*/st.wordChars( 0x21 , 0x21 );
    /*void*/st.wordChars( 0x23 , 0x7E );
    /*void*/st.wordChars( 0x80 , 0xF8 );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/
  /**
   * Tokenizer for parsing stream.
   */
  protected  StreamTokenizer	m_st;
  /**
   * Indicates if m_st has been positioned to first object.
   */
  protected  boolean		m_bPositioned		= false;


/*----------------------------------------------------------------------------
 *						Class Initializers
 *--------------------------------------------------------------------------*/

  static
  {
    /*void*/Config.init( true );		/* make sure it is loaded */
  }

/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String	argv[]	)
  {
    Parser		parser;
    Collectible		collectible	= null;

    try {
      parser = new Parser( new InputStreamReader( System.in ) );
      for ( ; null != (collectible = parser.parse( collectible != null )) ;
	    ) {
	/*void*/System.out.println(
		"complete?: " + collectible.isComplete(  ) );
	/*void*/System.out.println(
		"supported?: " + collectible.isSupported(  ) );
	/*void*/System.out.println(
		"=======================================" +
		"=======================================" );
	/*void*/System.out.print( collectible );
	/*void*/System.out.println(
		"=======================================" +
		"=======================================" );
	/*void*/System.out.print(
		new ComponentDumper( (Component)collectible , "" ) );
      };
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
  }

}


/* Log:
 *  0.10  2003/06/16 - 2003/06/18  slh
 *        round 2
 *  0.00  2003/01/07 ... 2003/02/04, 2003/04/22 - 2003/04/23  slh
 *        create
 */
/*--Parser.java-------------------------------------------------------------*/
