/*++Owner.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.IANAParam;
import  edu.washington.cac.calendar.icalendar.XParam;


/**
 * CAP OWNER property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.24 [CAP-10]
 *   occurs:	VAGENDA (1+)
 *   datatypes:	UPN (1)
 *   default:	---
 *   allowed:	---
 *   params:	ianaparam(0+), xparam(0+)
 *???8.24 prose says LANGUAGE(0-1), ALTREP(0-1) are present,
 *???abnf does not, seems unlikely
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/04/29 slh
 */
public
class  Owner
extends  UPNProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a OWNER property, unset.
   */
  public
  Owner  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a OWNER property set to supplied value.
   */
  public
  Owner  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Owner;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( IANAParam.class );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	args[]	)
  {
    Owner	owner		= new Owner(  );

    try {
      /*void*/System.out.println( owner );

      /*void*/owner.set( "slh@slh.net" );
      /*void*/System.out.println( owner );
      /*void*/owner.set( "@slh.net" );
      /*void*/System.out.println( owner );
      /*void*/owner.set( "@" );
      /*void*/System.out.println( owner );

      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/owner.set( "slh@" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    try {
      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/owner.set( "slh.net" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    try {
      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/owner.set( "slh@slh@fish" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
  }

}


/* Log:
 *  0.01  2003/04/23, 2003/04/29  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        assume only ianaparam, xparam
 *        update to CAP-10
 *  0.00  2002/12/03 - 2002/12/04  slh
 *        create
 */
/*--Owner.java--------------------------------------------------------------*/
