/*++OptionsParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.TextParam;


/**
 * CAP OPTIONS parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.1, 10.1.5, 10.2, 10.4, 10.9 [CAP/09]
 *   occurs:	0-1 (CMD)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *
 * Command	DataType	Values	Class
 * ============	========	======	=====
 * DELETE	TEXT		"MARK"	CmdDeleteOptionsParam???
 * GENERATE-UID	INTEGER		>= 1	CmdGenerateUIDOptionsParam???
 * IDENTIFY	UPN		---	CmdIdentifyOptionsParam???
 * SET-LOCALE	TEXT/locale	TEXT	CmdSetLocaleOptionsParam???
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/01/29 slh
 */
public
class  OptionsParam
extends  TextParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a OPTIONS parameter.
   */
  public
  OptionsParam  (		)
  {
    super( Names.strParam_Options );
  }


  /**
   * Create a OPTIONS parameter set to supplied string value.
   */
  public
  OptionsParam  (String	strValue	)
  {
    super( Names.strParam_Options , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (String	strValue	)
  throws Exception	/* to support subclasses */
  {
    /*void*/super.set( strValue );

    if (m_param != null) {
      /*void*/m_param.set( strValue );
    }
  }


  /**
   * Set the type of OPTIONS parameter.
   *
   * @param
   * iType	a valid Cmd type value
   */
  public
  void
  setType  (int	iType	)
  {
    if (m_strValue != null) {
      switch (iType) {
      case Cmd.DELETE:
	m_param = new CmdDeleteOptionsParam( m_strValue );
	break;
      case Cmd.GENERATEUID:
	m_param = new CmdGenerateUIDOptionsParam( m_strValue );
	break;
      case Cmd.IDENTIFY:
	m_param = new CmdIdentifyOptionsParam( m_strValue );
	break;
      case Cmd.SETLOCALE:
	m_param = new CmdSetLocaleOptionsParam( m_strValue );
	break;
      default:
	m_param = null;
	break;
      }
    } else {
      switch (iType) {
      case Cmd.DELETE:
	m_param = new CmdDeleteOptionsParam(  );
	break;
      case Cmd.GENERATEUID:
	m_param = new CmdGenerateUIDOptionsParam(  );
	break;
      case Cmd.IDENTIFY:
	m_param = new CmdIdentifyOptionsParam(  );
	break;
      case Cmd.SETLOCALE:
	m_param = new CmdSetLocaleOptionsParam(  );
	break;
      default:
	m_param = null;
	break;
      }
    }
  }


  /**
   * Get the type of OPTIONS parameter.
   *
   * @return	the Cmd type of the parameter (possible NONE)
   */
  public
  int
  getType  (		)
  {
    if        (m_param instanceof CmdDeleteOptionsParam) {
      return Cmd.DELETE;					/*RETURN*/
    } else if (m_param instanceof CmdGenerateUIDOptionsParam) {
      return Cmd.GENERATEUID;					/*RETURN*/
    } else if (m_param instanceof CmdIdentifyOptionsParam) {
      return Cmd.IDENTIFY;					/*RETURN*/
    } else if (m_param instanceof CmdSetLocaleOptionsParam) {
      return Cmd.SETLOCALE;					/*RETURN*/
    } else {
      return Cmd.NONE;						/*RETURN*/
    }
  }


  public
  String
  getString  (		)
  {
    if (m_param != null) {
      return m_param.getString(  );				/*RETURN*/
    } else {
      return super.getString(  );				/*RETURN*/
    }
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  Parameter		m_param		= null;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    OptionsParam	optionsparam;

    try {
      optionsparam = new OptionsParam( "MARK" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.DELETE );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      optionsparam = new OptionsParam( "3" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.GENERATEUID );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      optionsparam = new OptionsParam( "slh@slh.net" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.IDENTIFY );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      optionsparam = new OptionsParam( "en_US" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.SETLOCALE );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( "NOTE: should throw an exception:" );
    try {
      optionsparam = new OptionsParam( "wuzzle" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.DELETE );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( e );
    }
    /*void*/System.out.println( "NOTE: should throw an exception:" );
    try {
      optionsparam = new OptionsParam( "wuzzle" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.GENERATEUID );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( e );
    }
    /*void*/System.out.println( "NOTE: should throw an exception:" );
    try {
      optionsparam = new OptionsParam( "wuzzle" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.IDENTIFY );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( e );
    }
    try {
      optionsparam = new OptionsParam( "wuzzle" );
      /*void*/System.out.println( optionsparam );
      /*void*/optionsparam.setType( Cmd.SETLOCALE );
      /*void*/System.out.println( optionsparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( e );
    }

  }

}


/* Log:
 *  0.00  2003/01/29  slh
 *        create
 */
/*--OptionsParam.java-------------------------------------------------------*/
