/*++Names.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


/**
 * CAP component, property and parameter names and values.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	[CAP/09+]
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/04/23 slh
 */
abstract public
class  Names
extends  edu.washington.cac.calendar.icalendar.Names
{

/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  /* 7. New Parameters (.1 - .2) */
  final static public  String	strParam_Enable		= "ENABLE";
  final static public  String	strParam_Local		= "LOCAL";

  /* 8. New Properties (.1 - .27) */
  final static public  String	strProp_AllowConflict	= "ALLOW-CONFLICT";
  final static public  String	strProp_AttCounter	= "ATT-COUNTER";
  final static public  String	strProp_CalId		= "CALID";
  final static public  String	strProp_CalMaster	= "CALMASTER";
  final static public  String	strProp_CARID		= "CARID";
  final static public  String	strProp_CSID		= "CSID";
  final static public  String	strProp_Decreed		= "DECREED";
  final static public  String	strProp_DefaultCharSet	= "DEFAULT-CHARSET";
  final static public  String	strProp_DefaultLocale	= "DEFAULT-LOCALE";
  final static public  String	strProp_DefaultTZID	= "DEFAULT-TZID";
  final static public  String	strProp_DefaultVCARs	= "DEFAULT-VCARS";
  final static public  String	strProp_Deny		= "DENY";
  final static public  String	strProp_Expand		= "EXPAND";
  final static public  String	strProp_Grant		= "GRANT";
  final static public  String	strProp_MaxDate		= "MAXDATE";
  final static public  String	strProp_MinDate		= "MINDATE";
  final static public  String	strProp_MultiPart	= "MULTIPART";
  final static public  String	strProp_Name		= "NAME";
  final static public  String	strProp_Owner		= "OWNER";
  final static public  String	strProp_Permission	= "PERMISSION";
  final static public  String	strProp_Query		= "QUERY";
  final static public  String	strProp_QueryId		= "QUERYID";
/* modification of icalendar one
  final static public  String	strProp_RequestStatus	= "REQUEST-STATUS";
*/
  final static public  String	strProp_Restriction	= "RESTRICTION";
  final static public  String	strProp_Scope		= "SCOPE";
  final static public  String	strProp_Target		= "TARGET";
/* modification of icalendar one
  final static public  String	strProp_Transp		= "TRANSP";
*/
  /* 8.20 PERMISSION Property */
  final static public  String	strValue_Search		= "SEARCH";
  final static public  String	strValue_Create		= "CREATE";
  final static public  String	strValue_Delete		= "DELETE";
  final static public  String	strValue_Modify		= "MODIFY";
  final static public  String	strValue_All		= "*";
  /* 8.27 TRANSP Property */
//???these two should be moved to icalendar.Names
  final static public  String	strValue_Opaque		= "OPAQUE";
  final static public  String	strValue_Transparent	= "TRANSPARENT";
  final static public  String	strValue_TransparentNoConflict	=
						"TRANSPARENT-NOCONFLICT";
  final static public  String	strValue_OpaqueNoConflict	=
						"OPAQUE-NOCONFLICT";

  /* 9. New Components (.1 - .6) */
  final static public  String	strComp_VAgenda		= "VAGENDA";
  final static public  String	strComp_VCalStore	= "VCALSTORE";
  final static public  String	strComp_VCAR		= "VCAR";
  final static public  String	strComp_VRight		= "VRIGHT";
  final static public  String	strComp_VReply		= "VREPLY";
  final static public  String	strComp_VQuery		= "VQUERY";
  /* 9.2 */
//???not formally defined
  final static public  String	strProp_Children	= "CHILDREN";

  /* 10. Commands and Responses */
  final static public  String	strProp_Cmd		= "CMD";
  final static public  String	strParam_Id		= "ID";
  final static public  String	strParam_Localize	= "LOCALIZE";
  final static public  String	strParam_Latency	= "LATENCY";
  final static public  String	strParam_Action		= "ACTION";
  final static public  String	strParam_Options	= "OPTIONS";
  final static public  String	strCmd_Abort		= "ABORT";
  final static public  String	strCmd_Continue		= "CONTINUE";
  final static public  String	strCmd_Create		= "CREATE";
  final static public  String	strCmd_Delete		= "DELETE";
  final static public  String	strCmd_GenerateUID	= "GENERATE-UID";
  final static public  String	strCmd_GetCapability	= "GET-CAPABILITY";
  final static public  String	strCmd_Identify		= "IDENTIFY";
  final static public  String	strCmd_Modify		= "MODIFY";
  final static public  String	strCmd_Move		= "MOVE";
  final static public  String	strCmd_Reply		= "REPLY";
  final static public  String	strCmd_Search		= "SEARCH";
  final static public  String	strCmd_SetLocale	= "SET-LOCALE";
  final static public  String	strCmd_TimeOut		= "TIMEOUT";
  /* parameter values */
  final static public  String	strValue_Ask		= "ASK";
  final static public  String	strValue_Abort		= "ABORT";
  final static public  String	strValue_Mark		= "MARK";

  /* 10.3 GET-CAPABILITY Command */
  final static public  String	strProp_CAPVersion	= "CAP-VERSION";
  final static public  String	strProp_CARLevel	= "CAR-LEVEL";
  final static public  String	strProp_Components	= "COMPONENTS";
  final static public  String	strProp_StoresExpanded	= "STORES-EXPANDED";
  final static public  String	strProp_ITIPVersion	= "ITIP-VERSION";
  final static public  String	strProp_MaxCompSize	= "MAX-COMP-SIZE";
/* properly in with properties
  final static public  String	strProp_MultiPart	= "MULTIPART";
*/
/* same as icalendar one
  final static public  String	strProp_ProdId		= "PRODID";
*/
  final static public  String	strProp_QueryLevel	= "QUERY-LEVEL";
  final static public  String	strProp_RecurAccepted	= "RECUR-ACCEPTED";
  final static public  String	strProp_RecurExpand	= "RECUR-EXPAND";
  final static public  String	strProp_RecurLimit	= "RECUR-LIMIT";
/* same as icalendar one
  final static public  String	strProp_Version		= "VERSION";
*/
  /* x-prop */
  /* property values */
  final static public  String	strValue_CalQLNone	= "CAL-QL-NONE";
  final static public  String	strValue_CalQL1		= "CAL-QL-1";
  final static public  String	strValue_CARNone	= "CAR-NONE";
  final static public  String	strValue_CARMin		= "CAR-MIN";
  final static public  String	strValue_CARFull1	= "CAR-FULL-1";

}


/* Log:
 *  0.01  2003/02/05, 2003/04/23, 2003/04/28  slh
 *        (new year, new version...)
 *        rm DateMax/Min
 *        MAX-COMPONENT-SIZE -> MAX-COMP-SIZE
 *        NONE -> CAL-QL-NONE
 *  0.00  2002/10/23 ... 2002/11/13, 2002/12/09, 2002/12/11  slh
 *        create
 */
/*--Names.java--------------------------------------------------------------*/
