/*++Name.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.TextProp;
import  edu.washington.cac.calendar.icalendar.LanguageParam;
import  edu.washington.cac.calendar.icalendar.IANAParam;
import  edu.washington.cac.calendar.icalendar.XParam;


/**
 * CAP NAME property.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * ``
 * localizeable display name.  If more than one NAME property is in a
 * component, then they MUST have unique LANG parameters.  If the LANG
 * ''
 * This needs to be enforced by the container.
 *
 * Spec:
 *   section:	8.23 [CAP-10]
 *   occurs:	(0+)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	LANGUAGE(0-1), ianaparam(0+), xparam(0+)
 * </PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/29 slh
 */
public
class  Name
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a NAME property, unset.
   */
  public
  Name  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a NAME property set to supplied value.
   */
  public
  Name  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Name;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add( LanguageParam.class );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( IANAParam.class );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/23, 2003/04/29  slh
 *        (new year, new version...)
 *        allow ianaparam
 *        getCalendarName()
 *        trim unnec imports
 *        update to CAP-10
 *        configProperty()
 *  0.00  2002/11/05  slh
 *        create
 */
/*--Name.java---------------------------------------------------------------*/
