/*++MultiPart.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP MULTIPART property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.17 [CAP/09]
 *   occurs:	1 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (0+)
 *   default:	""
 *   allowed:	---
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/12/11 slh
 */
public
class  MultiPart
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a MULTIPART property with default value.
   */
  public
  MultiPart  (		)
  {
    super( Names.strProp_MultiPart );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) + ": internal error: " + e );
    }
  }


  /**
   * Create a MULTIPART property set to supplied value.
   */
  public
  MultiPart  (String	strValue	)
  {
    super( Names.strProp_MultiPart , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	= "";

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--MultiPart.java----------------------------------------------------------*/
