/*++MinDate.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Date;

import  edu.washington.cac.calendar.icalendar.TimeProp;


/**
 * CAP MINDATE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.16
 *   occurs:	VCALSTORE, VREPLY (GET-CAPABILTIES)??? (1)
 *   datatypes:	DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2002/11/25 slh
 */
public
class  MinDate
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a MINDATE property, unset.
   */
  public
  MinDate  (		)
  {
    super( getCalendarName(  ) , DATETIME , true );
  }


  /**
   * Create a MINDATE property set to supplied value.
   */
  public
  MinDate  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , true );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_MinDate;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME" );
    }

    /*void*/super.setType( Type );
  }


  /*Note: Property.addParameter() does the right thing: only allows xparams*/

}


/* Log:
 *  0.01  2003/11/25  slh
 *        update for change in TimeProp
 *        sync with current paradigms
 *  0.00  2002/10/28, 2002/10/29, 2002/12/11  slh
 *        create from DateMax.java
 */
/*--MinDate.java------------------------------------------------------------*/
