/*++MaxDate.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Date;

import  edu.washington.cac.calendar.icalendar.TimeProp;


/**
 * CAP MAXDATE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.15 [CAP/09]
 *   occurs:	VCALSTORE, VREPLY (GET-CAPABILTIES)??? (1)
 *   datatypes:	DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/11/25 slh
 */
public
class  MaxDate
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a MAXDATE property, unset.
   */
  public
  MaxDate  (		)
  {
    super( getCalendarName(  ) , DATETIME , true );
  }


  /**
   * Create a MAXDATE property set to supplied value.
   */
  public
  MaxDate  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , true );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_MaxDate;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME" );
    }

    /*void*/super.setType( Type );
  }


  /*Note: Property.addParameter() does the right thing: only allows xparams*/

}


/* Log:
 *  0.01  2003/11/25  slh
 *        update for change in TimeProp
 *        sync with current paradigms
 *  0.00  2002/10/28, 2002/10/29, 2002/12/11  slh
 *        create from Created.java
 */
/*--MaxDate.java------------------------------------------------------------*/
