/*++MaxCompSize.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.NonnegativeIntegerProp;
import  edu.washington.cac.calendar.icalendar.IANAParam;
import  edu.washington.cac.calendar.icalendar.XParam;


/**
 * CAP MAX-COMP-SIZE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.19 [CAP-10]
 *   occurs:	VREPLY/GET-CAPABILITY (1)
 *   datatypes:	INTEGER/nonnegative (1)
 *   default:	---
 *   allowed:	>= 0
 *   params:	ianaparam(0+), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.20 2003/04/30 slh
 */
public
class  MaxCompSize
extends  NonnegativeIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a MAX-COMP-SIZE property, unset.
   */
  public
  MaxCompSize  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a MAX-COMP-SIZE property set to indicated value.
   */
  public
  MaxCompSize  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a MAX-COMP-SIZE property set to indicated value.
   */
  public
  MaxCompSize  (Integer	IValue	)
  {
    super( getCalendarName(  ) , IValue );
  }


  /**
   * Create a MAX-COMP-SIZE property set to indicated value.
   */
  public
  MaxCompSize  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_MaxCompSize;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( IANAParam.class );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }

}


/* Log:
 *  0.20  2003/04/28 - 2003/04/30  slh
 *        rename from MaxComponentSize (as per CAP-10)
 *        allow ianaparam, xparam
 *        getCalendarName()
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        derive from NonnegativeIntegerProp (vs NaturalNumberProp)
 *        MaxComponentSize(Integer), MaxComponentSize(int)
 *  0.00  2002/10/30  slh
 *        create from LatencyParam.java
 */
/*--MaxCompSize.java--------------------------------------------------------*/
