/*++LocalParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.BooleanParam;


/**
 * CAP LOCAL parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	7.1 [CAP/09]
 *   occurs:	0-1 (VALARM.SEQUENCE)
 *   datatypes:	BOOLEAN (1)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/11/13 slh
 */
public
class  LocalParam
extends  BooleanParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a LOCAL parameter, unset.
   */
  public
  LocalParam  (		)
  {
    super( Names.strParam_Local );
  }


  /**
   * Create a LOCAL parameter set to supplied value.
   */
  public
  LocalParam  (String	strValue	)
  {
    super( Names.strParam_Local , strValue );
  }


  /**
   * Create a LOCAL parameter set to supplied value.
   */
  public
  LocalParam  (int	iValue	)
  {
    super( Names.strParam_Local , iValue );
  }


  /**
   * Create a LOCAL parameter set to supplied value.
   */
  public
  LocalParam  (boolean	bValue	)
  {
    super( Names.strParam_Local , bValue );
  }

}


/* Log:
 *  0.00  2002/11/13  slh
 *        create from Enable.java
 */
/*--LocalParam.java---------------------------------------------------------*/
