/*++LatencyParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.NaturalNumberParam;
import  edu.washington.cac.calendar.icalendar.ICalendarException;


/**
 * CAP LATENCY parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.1
 *   occurs:	0-1 (CMD)
 *   datatypes:	INTEGER/natural number (1)
 *   default:	---
 *   allowed:	>= 1???
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/10/30 slh
 */
public
class  LatencyParam
extends  NaturalNumberParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  LatencyParam  (		)
  {
    super( Names.strParam_Latency );
  }


  public
  LatencyParam  (String	strValue	)
  {
    super( Names.strParam_Latency );

    /*void*/set( strValue );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    LatencyParam	latencyparam	= new LatencyParam(  );

    /*void*/System.out.println( latencyparam );

    /*void*/latencyparam.set( 9 );
    /*void*/System.out.println( latencyparam );

    try {
      /*void*/System.out.println( latencyparam.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/latencyparam.set( -1 );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( latencyparam );
  }

}


/* Log:
 *  0.01  2002/10/30  slh
 *        derive from NaturalNumberParam instead of IntParam
 *        LatencyParam(String)
 *  0.00  2002/10/23  slh
 *        create from Sequence.java
 */
/*--LatencyParam.java-------------------------------------------------------*/
