/*++ITIPVersion.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP ITIP-VERSION property.
 *
 * ``MUST include at least "2447" to specify RFC-2447 support''.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.3
 *   occurs:	1 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (1+)
 *   default:	"2447"
 *   allowed:	"2447", ...
 *   params:	xparam (0+)???
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/10/29 slh
 */
public
class  ITIPVersion
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ITIP-VERSION property with default value.
   */
  public
  ITIPVersion  (		)
  {
    super( Names.strProp_ITIPVersion );

    try {
      /*void*/set( strCurrentVersion );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) +
		": internal error: " + e.getLocalizedMessage(  ) );
    }
  }


  /**
   * Create a ITIP-VERSION property set to supplied value.
   */
  public
  ITIPVersion  (String	strValue	)
  {
    super( Names.strProp_ITIPVersion );

    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
//???this plus check for containing strCurrentVersion
    return super.isComplete(  );
  }


  /*Note: Property.addParameter() does the right thing: only allows xparams*/


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strCurrentVersion	= "2447";

}


/* Log:
 *  0.00  2002/10/29  slh
 *        create
 */
/*--ITIPVersion.java--------------------------------------------------------*/
