/*++Expand.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.BooleanProp;


/**
 * CAP EXPAND property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.13 [CAP/09]
 *   occurs:	1 (VQUERY)
 *   datatypes:	BOOLEAN (1)
 *   default:	"FALSE"
 *   allowed:	---
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/02 slh
 */
public
class  Expand
extends  BooleanProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a EXPAND property set to default.
   */
  public
  Expand  (		)
  {
    this( mc_strDefault );
  }


  /**
   * Create a EXPAND property set to supplied value.
   */
  public
  Expand  (String	strValue	)
  {
    super( Names.strProp_Expand , strValue );
  }


  /**
   * Create a EXPAND property set to supplied value.
   */
  public
  Expand  (int	iValue	)
  {
    super( Names.strProp_Expand , iValue );
  }


  /**
   * Create a EXPAND property set to supplied value.
   */
  public
  Expand  (boolean	bValue	)
  {
    super( Names.strProp_Expand , bValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	mc_strDefault	= "FALSE";

}


/* Log:
 *  0.00  2002/12/02  slh
 *        create from StoresExpanded.java
 */
/*--Expand.java-------------------------------------------------------------*/
