/*++EnableParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.BooleanParam;


/**
 * CAP ENABLE parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	7.1 [CAP/09]
 *   occurs:	0-1 (TRIGGER)
 *   datatypes:	BOOLEAN (1)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/11/13 slh
 */
public
class  EnableParam
extends  BooleanParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ENABLE parameter, unset.
   */
  public
  EnableParam  (		)
  {
    super( Names.strParam_Enable );
  }


  /**
   * Create a ENABLE parameter set to supplied value.
   */
  public
  EnableParam  (String	strValue	)
  {
    super( Names.strParam_Enable , strValue );
  }


  /**
   * Create a ENABLE parameter set to supplied value.
   */
  public
  EnableParam  (int	iValue	)
  {
    super( Names.strParam_Enable , iValue );
  }


  /**
   * Create a ENABLE parameter set to supplied value.
   */
  public
  EnableParam  (boolean	bValue	)
  {
    super( Names.strParam_Enable , bValue );
  }

}


/* Log:
 *  0.00  2002/11/13  slh
 *        create from RecurExpand.java
 */
/*--EnableParam.java--------------------------------------------------------*/
