/*++DefaultVCARs.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP DEFAULT-VCARS property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.11 [CAP/09]
 *   occurs:	1 (VCALSTORE)
 *   datatypes:	TEXT (1+)
 *   default:	"READBUSYTIMEINFO,REQUESTONLY,UPDATEPARTSTATUS,DEFAULTOWNER"
 *   allowed:	---
 *   params:	xparam (0+)
 *
 * ``Description: This property is used in the "VCALSTORE" component to
 *   specify the "CARID" value of the "VCAR" components that MUST BE
 *   copied into now "VAGENDA" components at creation time by the CS.  All
 *   "DEFAULT-VCAR" values must have "VCARS" components stored in the
 *   "VCALSTORE".''
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/12/11 slh
 */
public
class  DefaultVCARs
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DEFAULT-VCARS property with default value.
   */
  public
  DefaultVCARs  (		)
  {
    super( Names.strProp_DefaultVCARs );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) + ": internal error: " + e );
    }
  }


  /**
   * Create a DEFAULT-VCARS property set to supplied value.
   */
  public
  DefaultVCARs  (String	strValue	)
  {
    super( Names.strProp_DefaultVCARs , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	=
		"READBUSYTIMEINFO,REQUESTONLY,UPDATEPARTSTATUS,DEFAULTOWNER";

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--DefaultVCARs.java-------------------------------------------------------*/
