/*++DefaultTZID.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP DEFAULT-TZID property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.10 [CAP/09]
 *   occurs:	1 (VAGENDA, VCALSTORE)
 *   (VAGENDA:)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   (VCALSTORE:)
 *   datatypes:	TEXT (1+)
 *   default:	"UTC"
 *   allowed:	``values are the same as the "TZID" property
 *		  as defined in [iCAL]''
 *   params:	xparam (0+)
 *
 * (VCALSTORE:)
 * ``The first entry in the list is used as the default TZID for
 *   all newly created calendars.
 *   The list MUST contain at least "UTC".''
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/12/11 slh
 */
public
class  DefaultTZID
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DEFAULT-TZID property with default value.
   */
  public
  DefaultTZID  (		)
  {
    super( Names.strProp_DefaultTZID );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) + ": internal error: " + e );
    }
  }


  /**
   * Create a DEFAULT-TZID property set to supplied value.
   */
  public
  DefaultTZID  (String	strValue	)
  {
    super( Names.strProp_DefaultTZID , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	= "UTC";

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--DefaultTZID.java--------------------------------------------------------*/
