/*++DefaultLocale.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP DEFAULT-LOCALE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.9 [CAP/09]
 *   occurs:	1 (VAGENDA, VCALSTORE)
 *   (VAGENDA:)
 *   datatypes:	TEXT (1)
 *   default:	"POSIX"
 *   (VCALSTORE:)
 *   datatypes:	TEXT (1+)
 *   default:	"POSIX"
 *   allowed:	locale
 *   params:	xparam (0+)
 *
 * (VCALSTORE:)
 * ``The first value in the list is the default for
 *   all newly created VAGENDAs.
 *   "POSIX" MUST BE in the list.''
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/12/11 slh
 */
public
class  DefaultLocale
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DEFAULT-LOCALE property with default value.
   */
  public
  DefaultLocale  (		)
  {
    super( Names.strProp_DefaultLocale );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) + ": internal error: " + e );
    }
  }


  /**
   * Create a DEFAULT-LOCALE property set to supplied value.
   */
  public
  DefaultLocale  (String	strValue	)
  {
    super( Names.strProp_DefaultLocale , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	= "POSIX";

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--DefaultLocale.java------------------------------------------------------*/
