/*++DefaultCharSet.java+++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP DEFAULT-CHARSET property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.8 [CAP/09]
 *   occurs:	1 (VAGENDA, VCALSTORE)
 *   (VAGENDA:)
 *   datatypes:	TEXT (1???)
 *   default:	""???
 *   (VCALSTORE:)
 *   datatypes:	TEXT (1+)
 *   default:	"UTF-8"
 *   allowed:	``IANA registered character set as defined in [CHARREG]''
 *   params:	xparam (0+)
 *
 * (VAGENDA:)
 * ``If not specified, the default is the first value in
 *   the "VCALSTORE" components "DEFAULT-CHARSET" property value list.''
 * (VCALSTORE:)
 * ``The first entry is the default entry for
 *   all newly created "VAGENDA" components.''
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/12/11 slh
 */
public
class  DefaultCharSet
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DEFAULT-CHARSET property with default value.
   */
  public
  DefaultCharSet  (		)
  {
    super( Names.strProp_DefaultCharSet );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) + ": internal error: " + e );
    }
  }


  /**
   * Create a DEFAULT-CHARSET property set to supplied value.
   */
  public
  DefaultCharSet  (String	strValue	)
  {
    super( Names.strProp_DefaultCharSet , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	= "UTF-8";

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--DefaultCharSet.java-----------------------------------------------------*/
