/*++Components.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP COMPONENTS property.
 *
 * ``MUST include at least VCALSTORE, VCALENDAR, VREPLY, and VAGENDA and
 *   at least one of VEVENT, VTODO, VTIMEZONE, or VJOURNAL''.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.3
 *   occurs:	1 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (1+)
 *   default:	"VCALSTORE,VCALENDAR,VREPLY,VAGENDA"
 *   allowed:	"VCALSTORE", "VCALENDAR", "VREPLY", "VAGENDA",
 *		"VEVENT", "VTODO", "VTIMEZONE", "VJOURNAL"
 *   params:	xparam (0+)???
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/10/29 slh
 */
public
class  Components
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a COMPONENTS property with default value.
   */
  public
  Components  (		)
  {
    super( Names.strProp_Components );

    try {
      /*void*/set( strMandatory );
    } catch (Exception	e	) {
      /* well, this should not have happened... */
      throw new Error( getName(  ) +
		": internal error: " + e.getLocalizedMessage(  ) );
    }
  }


  /**
   * Create a COMPONENTS property set to supplied value.
   */
  public
  Components  (String	strValue	)
  {
    super( Names.strProp_Components );

    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
//???this plus check for containing strMandatory and at least one of VEVENT, VTODO, VTIMEZONE, or VJOURNAL
    return super.isComplete(  );
  }


  /*Note: Property.addParameter() does the right thing: only allows xparams*/


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	strMandatory	=
					"VCALSTORE,VCALENDAR,VREPLY,VAGENDA";

}


/* Log:
 *  0.00  2002/10/29  slh
 *        create
 */
/*--Components.java---------------------------------------------------------*/
