/*++CmdSetLocaleOptionsParam.java+++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextParam;


/**
 * CAP (CMD SET-LOCALE) OPTIONS parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.9 [CAP/09]
 *   occurs:	0-1 (CMD/SET-LOCALE)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
public
class  CmdSetLocaleOptionsParam
extends  TextParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a (CMD SET-LOCALE) OPTIONS parameter, unset.
   */
  public
  CmdSetLocaleOptionsParam  (		)
  {
    super( Names.strParam_Options );
  }


  /**
   * Create a (CMD SET-LOCALE) OPTIONS parameter set to supplied value.
   */
  public
  CmdSetLocaleOptionsParam  (String	strValue	)
  {
    super( Names.strParam_Options , strValue );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    CmdSetLocaleOptionsParam	cmdsetlocaleoptionsparamparam	=
					new CmdSetLocaleOptionsParam(  );

    /*void*/System.out.println( cmdsetlocaleoptionsparamparam );

    try {
      /*void*/cmdsetlocaleoptionsparamparam.set( "666 42 69" );
      /*void*/System.out.println( cmdsetlocaleoptionsparamparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( cmdsetlocaleoptionsparamparam.get(  ) );
    /*void*/System.out.println( cmdsetlocaleoptionsparamparam );
  }

}


/* Log:
 *  0.00  2002/12/10  slh
 *        create LocalizeParam.java
 */
/*--CmdSetLocaleOptionsParam.java-------------------------------------------*/
