/*++CmdIdentifyOptionsParam.java++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


/**
 * CAP (CMD IDENTIFY) OPTIONS parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.4 [CAP/09]
 *   occurs:	0-1 (CMD/IDENTIFY)
 *   datatypes:	UPN (1)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
public
class  CmdIdentifyOptionsParam
extends  UPNParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a (CMD IDENTIFY) OPTIONS parameter, unset.
   */
  public
  CmdIdentifyOptionsParam  (		)
  {
    super( Names.strParam_Options );
  }


  /**
   * Create a (CMD IDENTIFY) OPTIONS parameter set to supplied value.
   */
  public
  CmdIdentifyOptionsParam  (String	strValue	)
  {
    super( Names.strParam_Options , strValue );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	args[]	)
  {
    CmdIdentifyOptionsParam	cmdidentifyoptionsparam		=
					new CmdIdentifyOptionsParam(  );

    try {
      /*void*/System.out.println( cmdidentifyoptionsparam );

      /*void*/cmdidentifyoptionsparam.set( "slh@slh.net" );
      /*void*/System.out.println( cmdidentifyoptionsparam );
      /*void*/cmdidentifyoptionsparam.set( "@slh.net" );
      /*void*/System.out.println( cmdidentifyoptionsparam );
      /*void*/cmdidentifyoptionsparam.set( "@" );
      /*void*/System.out.println( cmdidentifyoptionsparam );

      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/cmdidentifyoptionsparam.set( "slh@" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    try {
      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/cmdidentifyoptionsparam.set( "slh.net" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    try {
      /*void*/System.out.println(
		"NOTE: should throw MalformedUPNException:" );
      /*void*/cmdidentifyoptionsparam.set( "slh@slh@fish" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
  }

}


/* Log:
 *  0.00  2002/12/10  slh
 *        create
 */
/*--CmdIdentifyOptionsParam.java--------------------------------------------*/
